/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.textbox;

import com.queplix.core.client.controls.QFormElement;
import com.queplix.core.client.controls.QFormElementController;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementView;
import com.queplix.core.client.app.vo.TextBoxFieldMeta;

public class QTextBox implements QFormElement {
    
    private QTextBoxControllerImpl controller;
    private QTextBoxModelImpl model;
    private QTextBoxViewImpl view;
    
    public QTextBox(TextBoxFieldMeta meta, int layout) {
        model = new QTextBoxModelImpl(meta);
        view = new QTextBoxViewImpl(model, layout, meta.isMasked());
        controller = new QTextBoxControllerImpl(model, view);
    }
    
    public QFormElementModel getBaseModel(){
        return model;
    }
    
    public QFormElementView getBaseView(){
        return view;
    }

    public QFormElementController getBaseController() {
        return controller;
    }

    public QTextBoxController getController(){
        return controller;
    }
    
    public QTextBoxModel getModel(){
        return model;
    }
    
    public QTextBoxView getView(){
        return view;
    }
    
}
