/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.frames.adhoc;

import com.queplix.core.client.common.ui.OkayCancelPopup;
import com.queplix.core.client.common.ui.DialogHelper;
import com.queplix.core.client.common.event.EventListener;
import com.queplix.core.client.common.event.Event;
import com.queplix.core.client.common.StringUtil;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.KeyboardListenerAdapter;

/**
 * Implements input dialog with "yes" and "no" controls with single input line.
 *
 * @author Sergey Kozmin
 * @since 13.03.2007
 */
public class SingleLineInputDialog extends OkayCancelPopup {
    private TextBox reportNameTextBox;
    private Label inputDescription;

    public SingleLineInputDialog(String caption, String inputDescriptionMessage, boolean doNotCloseOnEvent) {
        super(caption, doNotCloseOnEvent);
        VerticalPanel mainPanel = new VerticalPanel();
        inputDescription = new Label(inputDescriptionMessage);
        mainPanel.add(this.inputDescription);
        reportNameTextBox = new TextBox();
        mainPanel.add(reportNameTextBox);

        reportNameTextBox.addKeyboardListener(new KeyboardListenerAdapter() {
            public void onKeyPress(Widget sender, char keyCode, int modifiers) {
                if(keyCode == KEY_ENTER) {
                    SingleLineInputDialog.this.getEventSource().fireEvent(OkayCancelPopup.Events.OK);
                } else if(keyCode == KEY_ESCAPE) {
                    SingleLineInputDialog.this.getEventSource().fireEvent(OkayCancelPopup.Events.CANCEL);
                }
            }
        });

        setWidget(mainPanel);
    }

    public String getInputText() {
        return reportNameTextBox.getText();
    }

    public void reset() {
        reportNameTextBox.setText("");
    }

    public void setInputText(String text) {
        reportNameTextBox.setText(text);
    }

    public void setLineDescription(String description) {
        inputDescription.setText(description);
    }

    public void show() {
        super.show();
        reportNameTextBox.setFocus(true);
    }

    public void show(int left, int top) {
        super.show(left, top);
        reportNameTextBox.setFocus(true);
    }

    public void show(Widget nextTo) {
        super.show(nextTo);
        reportNameTextBox.setFocus(true);
    }
}
