/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.frames.mainframe;

import com.queplix.core.client.app.rpc.RPC;
import com.queplix.core.client.app.vo.FamgMeta;

/**
 * Class defines base command class for all business responses
 *
 * @author Sergey Kozmin
 * @since 11.04.2007
 */
public class BusinessCommand extends RPC.QAsyncCallback
        implements BusinessCommandType {

    private BusinessCommandExecutor executor;
    /**
     * Can holds custom status
     */
    private int commandType;

    public BusinessCommand(BusinessCommandExecutor executor, int commandType) {
        this.executor = executor;
        this.commandType = commandType;
    }

    public void onRequestEnded(boolean success, Object result) {
        executor.execute(commandType, this, success, result);
    }

    protected void handleError(Throwable error) {
        executor.handleError(commandType, this, error);
    }

    protected void defaultHandleError(Throwable error) {
        super.handleError(error);
    }

    public int getCommandType() {
        return commandType;
    }
}
