/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.frames.mainframe;

import com.queplix.core.client.app.vo.MetaData;

/**
 * This entity is needed in application, to encapsulate concrete objects types.
 * All the mainframes, strategies and context will be encapsulated by this
 * builder interface.
 *
 * @author Sergey Kozmin
 * @since 11.04.2007
 */
public interface MainFrameBuilder {
    /**
     * This method should be called before all other. Otherwise
     * {@link IllegalStateException} will be called
     * @param meta meta metadata on which mainframe implementation should be based
     */
    public void initBuilder(MetaData meta);
    /**
     * @return strategies factory object that can be retrieved
     * from any application
     */
    public StrategiesFactory getStrategiesFactory();

    /**
     * Returns operation context for the created MainFrame
     * @return operation context
     */
    public OperationContext getOperationContext();

    /**
     * Returns mainframe object
     * @return mainframe object
     */
    public IMainFrame getMainFrame();
}
