/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.frames.mainframe;

import com.google.gwt.user.client.ui.Widget;

import java.util.Map;

/**
 * We don't want to open mainframe implementation, to avoid package dependencies,
 * hence we wrap object and delegete methods. 
 *
 * @author Sergey Kozmin
 * @since 13.04.2007
 */
public class MainFrameWrapper implements IMainFrame {
    private IMainFrame delegateTarget;

    public MainFrameWrapper(IMainFrame delegateTarget) {
        this.delegateTarget = delegateTarget;
    }

    public void initMainFrame(StrategiesFactory factory) {
        delegateTarget.initMainFrame(factory);
    }

    public Widget getView() {
        return delegateTarget.getView();
    }

    public void activated() {
        delegateTarget.activated();
    }

    public void disabled() {
        delegateTarget.disabled();
    }
}
