/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.frames.mainframe.impl;

import com.google.gwt.user.client.ui.*;
import com.queplix.core.client.i18n.I18N;
import com.queplix.core.client.common.ui.OkayCancelPopup;
import com.queplix.core.client.common.ui.DialogHelper;
import com.queplix.core.client.common.event.Event;
import com.queplix.core.client.common.event.EventListener;

/**
 * A simple box intended for search data saving
 * @author Vasily Mikhailitchenko
 * @since 15 Jan 2007
 */
class SaveSearchBox extends OkayCancelPopup {
    private ScrollPanel sp;
    private int left;
    private int top;
    private int state;

    public static interface Events {
        Event/*]<String>[*/ DO_SAVE_CURRENT_SEARCH = new Event();
    }

    public static final int NEW = 0;
    public static final int RENAME = -1;

    private TextBox textBox;
    private Label label;
    private VerticalPanel panel;

    public SaveSearchBox(String caption){
        super(caption);
        label = new Label(I18N.getMessages().enterTheName());
        textBox = new TextBox();
        // Usage of ScrollPanel is a work-around for Firefox:
        // it won't place text cursor in a textbox inside a floating div if
        // the "overflow" attribute of the div is not set to "auto"
        sp = new ScrollPanel();
        panel = new VerticalPanel();
        panel.add(label);
        panel.add(textBox);

        sp.setWidget(panel);
        setWidget(sp);
        getEventSource().addEventListener(initEventListener());

        KeyboardListenerAdapter enterPressedAdapter = new KeyboardListenerAdapter() {
          public void onKeyPress(Widget sender, char keyCode, int modifiers) {
            if (KeyboardListenerAdapter.KEY_ENTER == keyCode) {
               getEventSource().fireEvent(OkayCancelPopup.Events.OK);
            }
          }
        };
        textBox.addKeyboardListener(enterPressedAdapter);        
    }

    public String getName() {
        return textBox.getText();
    }

    public void show(int left, int top, int state) {
        this.left = left;
        this.top = top;
        this.state = state;

        if(this.state == NEW){
            textBox.setText("");
            label.setText(I18N.getMessages().enterTheName());
        } else if(state == RENAME){
            textBox.setText(getName() + "_"+I18N.getMessages().newSt());
            label.setText(I18N.getMessages().enterNewName());
        }
        super.show(this.left, this.top);
        sp.setAlwaysShowScrollBars(false);
        textBox.setFocus(true);
    }

    private EventListener initEventListener() {
        return new EventListener(){
            public void onEvent(Event event, Widget sender) {
                if(OkayCancelPopup.Events.OK.equals(event)){
                    if(!textBox.getText().equals("")){
                        Events.DO_SAVE_CURRENT_SEARCH.setData(getName());
                        getEventSource().fireEvent(Events.DO_SAVE_CURRENT_SEARCH);
                        hide();
                    } else {
                        DialogHelper.showModalMessageDialog(I18N.getMessages().searchNameEmpty());
                        show(left, top, state);
                    }
                } else if(OkayCancelPopup.Events.CANCEL.equals(event)){
                    hide();
                }
            }
        };
    }
}
