/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.frames.mainframe.impl;

import com.queplix.core.client.app.vo.FieldData;

/**
 * Implements command, that should tell form to set data.
 *
 * @author Sergey Kozmin
 * @since 31.10.2006, 16:29:43
 */
class SetDataForFormCommand extends FormCommand {
    private final static int COMMAND_TYPE = SET_DATA;
    private FieldData[] data;
    private Long rowID;
    private boolean clearOtherFields;

    public SetDataForFormCommand(FieldData[] data, Long rowID, boolean clearOtherFields) {
        super(COMMAND_TYPE);
        this.clearOtherFields = clearOtherFields;
        if(data == null) {
            this.data = new FieldData[0];
        } else {
            this.data = data;
        }
        this.rowID = rowID;
    }

    public SetDataForFormCommand(FieldData[] data, Long rowID) {
        this(data, rowID, true);
    }

    /**
     * Return value could not be null object
     * @return grid data
     */
    public FieldData[] getData() {
        return data;
    }

    public void setData(FieldData[] data) {
        if(data != null) {
            this.data = data;
        }
    }

    public Long getRowID() {
        return rowID;
    }

    public void setRowID(Long rowID) {
        this.rowID = rowID;
    }

    public boolean isClearOtherFields() {
        return clearOtherFields;
    }
}
