/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

/*
 * StatusBar.java
 *
 *  30  2006 ., 15:23
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.queplix.core.client.frames.mainframe.impl;

import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.queplix.core.client.app.vo.MetaData;
import com.queplix.core.client.common.ui.ButtonData;
import com.queplix.core.client.common.ui.IconButton;
import com.queplix.core.client.controls.datefield.DateHelper;
import java.util.Date;

/**
 *
 * @author alexander.epifanov
 */
class StatusBar extends HorizontalPanel {
    private static final String STYLE_PANEL = "statusBar";
    private static final String STYLE_DATELABEL = "statusBar_dateLabel";
    private static final String STYLE_TIMERLABEL = "statusBar_timerLabel";
    private static final String STYLE_TIMERBOX = "statusBar_timerBox";
    private static final String STYLE_BUTTON = "statusBar_button";
    
    private static final ButtonData START_BUTTON = new ButtonData(null, null, "timer/start_timer.gif");
    private static final ButtonData PAUSE_BUTTON = new ButtonData(null, null, "timer/pause_timer.gif");
    private static final ButtonData RESET_BUTTON = new ButtonData(null, null, "timer/reset_timer.gif");

    private Label dateLabel;
    private String status;
    IconButton startButton;
    IconButton resetButton;
    private boolean started;
    private int timeSeconds;
    private Label timerLabel;
    private HorizontalPanel timerBox;
    Timer t;
    
    /** Creates a new instance of StatusBar */
    public StatusBar(MetaData appMetaData) {
        this.setVerticalAlignment(ALIGN_MIDDLE);
        this.dateLabel = new Label("");
        this.dateLabel.setWordWrap(false);
        this.timerLabel = new Label("");
        this.timerBox = new HorizontalPanel();
        this.updateDate(true);
        this.started = false;
        this.t = new Timer() {                    
            public void run() {
                updateTimer();                
            }
        };
        t.scheduleRepeating(1000);
        this.add(this.dateLabel);
        this.initButtons();
        this.resetTimer();
        this.changeTimer();
        this.timerBox.add(this.timerLabel);
        this.timerBox.add(startButton);
        this.timerBox.add(resetButton);
        this.add(timerBox);
        this.setCellWidth(this.timerBox, "100%");
        
        this.setStyleName(STYLE_PANEL);
        this.dateLabel.addStyleName(STYLE_DATELABEL);
        this.timerLabel.addStyleName(STYLE_TIMERLABEL);
        this.timerBox.addStyleName(STYLE_TIMERBOX);
        this.startButton.addStyleName(STYLE_BUTTON);
        this.resetButton.addStyleName(STYLE_BUTTON);
    }
    
    private void initButtons() {
        startButton = new IconButton(START_BUTTON);
        startButton.addClickListener(new ClickListener() {
            public void onClick(Widget sender) {
                if(!started) {
                    startButton.setButtonState(PAUSE_BUTTON);
                    started = true;
                } else {
                    startButton.setButtonState(START_BUTTON);
                    started = false;
                }
            }
        });
        resetButton = new IconButton(RESET_BUTTON);
        resetButton.addClickListener(new ClickListener() {
            public void onClick(Widget sender) {
                resetTimer();
            }
        });
    }
    
    synchronized private void updateDate(boolean updateNow) {        
        Date date = new Date();
        long millSeconds = date.getTime();
//        if(updateNow || 0 == (millSeconds / 1000) % 60) { // use it for minutes update
        if(true) { // use it for seconds update
            date.setTime(DateHelper.getUserDate().getTime());
            this.dateLabel.setText(date.toLocaleString());
        }
    }
    
    synchronized private void updateTimer() {
        if(started) {
            this.timeSeconds++;
            this.changeTimer();
        }
        this.updateDate(false);
    }
    
    synchronized private void resetTimer() {
        this.timeSeconds = 0;
        this.changeTimer();
    }
    
    private void changeTimer() {
            int sec = this.timeSeconds % 60;
            int min = ((this.timeSeconds - sec) / 60) % 60;
            int hour = (((this.timeSeconds - sec) / 60) - min) / 60;
            this.timerLabel.setText((hour<10?"0":"")+hour+(min<10?":0":":")+min+(sec<10?":0":":")+sec);        
    }
}
