/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.frames.mainframe.impl;

import com.queplix.core.client.app.Application;
import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.SubFocusMeta;
import com.queplix.core.client.app.vo.TabMeta;
import com.queplix.core.client.common.event.EventSource;
import com.queplix.core.client.common.ui.resizable.ResizableLazyDeckPanel;
import com.queplix.core.client.controls.grid.QGrid;

/**
 * Postfix GA - Grid Area.
 * On tab(Focus->Sub Focus->Tab not QTab tab) change you should select corresponding TabGA in this class to show correct contents.
 * Class MainFrameGA contains array of FocusGA.
 * Class FocusGA contains array of SubFocusGA.
 * This class SubFocusGA contains array of TabGA.
 * Class TabGA contains array of QGrid.
 *
 * @author Aliaksandr Melnik
 * @since 19 Oct 2006
 */
class SubFocusGA extends ResizableLazyDeckPanel {

    // -------------------- public events ------------------------
    public static interface Events extends TabGA.Events {
    }

    private EventSource eventSource = new EventSource(this);

    public EventSource getEventSource() {
        return eventSource;
    }
    // ----------------- end of public events --------------------

    private TabGA[] tabsGA;
    private TabMeta[] tabsMeta;
    private String status;

    public SubFocusGA(SubFocusMeta subFocusMeta) {
        super(subFocusMeta.getTabs().length);
        status = Application.getStatus();
        tabsMeta = subFocusMeta.getTabs();
        tabsGA = new TabGA[tabsMeta.length];

        if(tabsGA.length > 0) {
            showWidget(0);
        }
    }

    public TabGA[] getTabsGA() {
        return tabsGA;
    }

    public void performCommand(GridCommand command, FamgMeta.Index formID) {
        TabGA tab = tabsGA[formID.tab];
        tab.performCommand(command, formID.famg);
//        tab.selectTab(formID.famg);
    }

    protected void createCard(int index) {
        tabsGA[index] = new TabGA(tabsMeta[index]);
        tabsGA[index].getEventSource().addEventListener(eventSource); // retranslate events
        remove(index);
        insert(tabsGA[index], index);
    }

    void activateTab(TabMeta.Index index) {
        showWidget(index.tab);
    }

    void activateGrid(FamgMeta.Index index) {
        activateTab(index);
        tabsGA[index.tab].activateGrid(index);
    }

    public FamgMeta.Index getSelectedFormIndex() {
        return tabsGA[getVisibleWidget()].getSelectedFormIndex();
    }

    public TabMeta.Index getSelectedTabIndex() {
        return tabsMeta[getVisibleWidget()].getIndex();
    }

    public void clearAllGrids() {
        for (int i = 0; i < tabsGA.length; i++) {
            if(tabsGA[i] != null) {
                tabsGA[i].clearAllGrids();
            }
        }
    }

    QGrid getGrid(FamgMeta.Index famgIndex) {
        TabGA tabGA = tabsGA[famgIndex.tab];
        return tabGA != null ? tabGA.getGrid(famgIndex) : null;
    }

    FamgMeta.Index getActiveGridIndex() {
        int activeTab = getVisibleWidget();
        FamgMeta.Index index = tabsGA[activeTab].getActiveGridIndex();
        index.tab = activeTab;
        return index;
    }

    void collectUISettings() {
        for (int i = 0; i < tabsGA.length; i++) {
            if(tabsGA[i] != null) {
                tabsGA[i].collectUISettings();
            }
        }
    }
}
