/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.i18n;

import com.google.gwt.core.client.GWT;

/**
 * Factory of internationalized messages.
 * @author Sultan Tezadov
 * @since 11 Dec 2006
 */
public final class I18N {
    private static final Messages messages;
    
    static {
        messages = (Messages) GWT.create(Messages.class);
    }
    
    private I18N() { } // no point of instantiation
    
    public static Messages getMessages() {
        return messages;
    }
}
