/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.integrator;

import com.queplix.core.modules.eql.ejb.HistoryLocal;
import com.queplix.core.modules.eql.ejb.LockManagerLocal;
import com.queplix.core.modules.eql.ejb.HistoryLocalHome;
import com.queplix.core.modules.eql.ejb.LockManagerLocalHome;
import com.queplix.core.modules.eql.ejb.EQLManagerLocal;
import com.queplix.core.modules.eql.ejb.EQLManagerLocalHome;
import com.queplix.core.modules.inbox.ejb.InboxManagerLocal;
import com.queplix.core.modules.inbox.ejb.InboxManagerLocalHome;
import com.queplix.core.modules.eqlext.ejb.GetRecordsLocal;
import com.queplix.core.modules.eqlext.ejb.SetRecordsLocal;
import com.queplix.core.modules.eqlext.ejb.GetRecordsLocalHome;
import com.queplix.core.modules.eqlext.ejb.SetRecordsLocalHome;
import com.queplix.core.modules.config.ejb.EntityViewConfigManagerLocal;
import com.queplix.core.modules.config.ejb.CaptionManagerLocal;
import com.queplix.core.modules.config.ejb.UserPropertyManagerLocal;
import com.queplix.core.modules.config.ejb.FocusConfigManagerLocal;
import com.queplix.core.modules.config.ejb.ContextMenuConfigManagerLocal;
import com.queplix.core.modules.config.ejb.EntityViewConfigManagerLocalHome;
import com.queplix.core.modules.config.ejb.CaptionManagerLocalHome;
import com.queplix.core.modules.config.ejb.UserPropertyManagerLocalHome;
import com.queplix.core.modules.config.ejb.FocusConfigManagerLocalHome;
import com.queplix.core.modules.config.ejb.ContextMenuConfigManagerLocalHome;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.utils.JNDINames;

import javax.servlet.ServletContext;

/**
 * Implements ActionContext interface for war project, based on servlet context.
 *
 * @author Sergey Kozmin
 * @since 14.03.2007
 */
public class ServletCacheActionContext implements ActionContext {
    private ServletContext ctx;

    public ServletCacheActionContext(ServletContext ctx) {
        this.ctx = ctx;
    }
    
    public HistoryLocal getHistoryManager() {
        return (HistoryLocal) SessionEjbHelper.getLocalObject(ctx, JNDINames.History, HistoryLocalHome.class);
    }

    public InboxManagerLocal getInboxManagerLocal() {
        return (InboxManagerLocal) SessionEjbHelper.getLocalObject(ctx, JNDINames.InboxManager, InboxManagerLocalHome.class);
    }

    public LockManagerLocal getRecordsLockManager() {
        return (LockManagerLocal) SessionEjbHelper.getLocalObject(ctx, JNDINames.LockManager,
                LockManagerLocalHome.class);
    }

    public GetRecordsLocal getRecordsManager() {
        return (GetRecordsLocal) SessionEjbHelper.getLocalObject(ctx, JNDINames.GetRecords, GetRecordsLocalHome.class);
    }

    public SetRecordsLocal getSetRecordsManager() {
        return (SetRecordsLocal) SessionEjbHelper.getLocalObject(ctx, JNDINames.SetRecords, SetRecordsLocalHome.class);
    }

    public EntityViewConfigManagerLocal getEntityViewConfigManager() {
        return (EntityViewConfigManagerLocal) SessionEjbHelper.getLocalObject(ctx,
                JNDINames.EntityViewConfigManager, EntityViewConfigManagerLocalHome.class);
    }

    public CaptionManagerLocal getCaptionManager() {
        return (CaptionManagerLocal) SessionEjbHelper.getLocalObject(ctx,
                JNDINames.CaptionManager, CaptionManagerLocalHome.class);
    }

    /**
     * Get UserPropertyManagerEJB local interface.
     * @return UserPropertyManagerLocal object
     */
    public UserPropertyManagerLocal getUserPropertyManager() {
        return (UserPropertyManagerLocal) SessionEjbHelper.getLocalObject(ctx,
                JNDINames.UserPropertyManager, UserPropertyManagerLocalHome.class);
    }

    public FocusConfigManagerLocal getFocusConfigManager() {
        return (FocusConfigManagerLocal) SessionEjbHelper.getLocalObject(ctx,
                JNDINames.FocusConfigManager, FocusConfigManagerLocalHome.class);
    }

    public ContextMenuConfigManagerLocal getContextMenuManager() {
        return (ContextMenuConfigManagerLocal) SessionEjbHelper.getLocalObject(ctx,
                JNDINames.ContextMenuConfigManager, ContextMenuConfigManagerLocalHome.class);
    }

    public JEOManagerLocal getJEOManager() {
        return (JEOManagerLocal) SessionEjbHelper.getLocalObject(ctx, JNDINames.JEOManager, JEOManagerLocalHome.class);
    }

    public EQLManagerLocal getEQLManager() {
        return (EQLManagerLocal) SessionEjbHelper.getLocalObject(ctx, JNDINames.EQLManager, EQLManagerLocalHome.class);
    }
}
