/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.integrator;

import com.queplix.core.utils.cache.CacheObjectManager;
import com.queplix.core.utils.log.AbstractLogger;
import com.queplix.core.utils.log.Log;

import javax.servlet.ServletContext;

/**
 * That class help to get/store ejbs in optimal way.
 *
 * @author Sergey Kozmin
 * @since 20.11.2006, 17:20:23
 */
class SessionEjbHelper {
    private static final AbstractLogger logger = Log.getLog(SessionEjbHelper.class);

    public static final String CACHE_OBJECT_MANAGER_KEY = "CACHE_OBJECT_MANAGER_KEY";

    /**
     * Gets Cache manager EJB reference.
     *
     * @param ctx ServletContext
     * @return CacheObjectManager object
     */
    public static CacheObjectManager getCacheObjectManager(ServletContext ctx) {
        CacheObjectManager com;
        synchronized (ctx) {
            if ((com = (CacheObjectManager) ctx.getAttribute(CACHE_OBJECT_MANAGER_KEY)) == null) {
                com = new CacheObjectManager();
                ctx.setAttribute(CACHE_OBJECT_MANAGER_KEY, com);
            }
        }
        return com;
    }

    /**
     * Gets EJB local reference.
     *
     * @param ctx       ServletContext
     * @param jndiName  JNDI name
     * @param homeClass home class
     * @return local object
     * @throws com.queplix.core.integrator.entity.CouldntGetEJBException if some error occured diring the ejb retrieving
     */
    public static Object getLocalObject(ServletContext ctx, String jndiName, Class homeClass) {
        return getCacheObjectManager(ctx).getLocalObject(jndiName, homeClass);
    }
}
