/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.security.www;

import com.queplix.core.jxb.error.QwException;
import com.queplix.core.utils.www.AbstractServlet;
import com.queplix.core.utils.www.ServletHelper;
import com.queplix.core.utils.xml.XMLHelper;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Exception handler.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:56 $
 * @see ErrorServletHelper
 */
public class ErrorServlet
    extends AbstractServlet {

    /* (non-Javadoc)
     * @see HttpServlet#service(HttpServletRequest, HttpServletResponse)
     */
    public void service( HttpServletRequest request, HttpServletResponse response )
        throws IOException, ServletException {

        ErrorServletHelper helper = new ErrorServletHelper( request );
        QwException exObject = helper.process();
        char[] message = XMLHelper.writeObject( exObject );

        if( !response.isCommitted() ) {
            response.reset();
            response.setHeader( "Cache-Control", "no-cache" );
            response.setHeader( "Pragma", "no-cache" );
            response.setContentType( ServletHelper.CONTENT_TYPE_XML );
            try {
                response.getWriter().println( message );
            } catch( Exception ex ) {
                response.getOutputStream().println( String.valueOf( message ) );
            }
            response.flushBuffer();
        } else {
            try {
                try {
                    response.getWriter().println( message );
                } catch( Exception ex ) {
                    response.getOutputStream().println( String.valueOf( message ) );
                }
                response.flushBuffer();
            } catch( IOException ex1 ) {}
        }
        System.out.println( message );
    }
}
