/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.services.www;

import com.queplix.core.error.IncorrectParameterException;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.integrator.security.SecurityException;
import com.queplix.core.integrator.security.*;
import com.queplix.core.modules.services.ejb.ScriptManager;
import com.queplix.core.modules.services.ejb.ScriptManagerHome;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.www.AbstractServlet;
import com.queplix.core.utils.www.ServletHelper;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.rmi.RemoteException;

/**
 * <p>Task servlet<p>
 * <strong>USAGE</strong>: <pre>Get /sys/task/start?id=1</pre>
 * <p>Start task<p>
 * <p><strong>Parameters</strong>:
 *      id: unique task id
 * </p>
 * <p>
 * <p>Stop task<p>
 * <strong>USAGE</strong>: <pre>Get /sys/task/stop?id=1</pre>
 * <p><strong>Parameters</strong>:
 *      id: unique task id
 * </p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:03 $
 */

public class TaskServlet
    extends AbstractServlet {

    //
    // Service method
    //
    public void service( HttpServletRequest req, HttpServletResponse res )
        throws IOException, ServletException {

        String action = req.getPathInfo();
        if( action != null ) {
            action = action.substring( 1 );
        } else {
            action = "";
        }

        // Perform action
        try {
            if( action.equalsIgnoreCase( "start" ) ) {
                doStartAction( req, res );
            } else if( action.equalsIgnoreCase( "stop" ) ) {
                doStopAction( req, res );
            } else {
                throw new IncorrectParameterException( "action", action );
            }

        } catch( SecurityException ex ) {
            throw new ServletException( ex );
        }
    }

    // ----------------------------------------------------------------- actions

    //
    // Start action
    //
    private void doStartAction( HttpServletRequest req, HttpServletResponse res )
        throws ServletException, com.queplix.core.integrator.security.SecurityException {

        // Initialization
        long taskId = ServletHelper.getParamAsLong( req, "id" );
        LogonSession ls = WebLoginManager.getLogonSession( req );

        // Set task status to "Ready"
        try {
            getScriptManager().readyTask( taskId, false );

        } catch( EQLException ex ) {
            throw new ServletException( ex );

        } catch( RemoteException ex ) {
            throw new ServletException( ex.detail );
        }
    }

    //
    // Stop action
    //
    private void doStopAction( HttpServletRequest req, HttpServletResponse res )
        throws ServletException, SecurityException {

        // Initialization
        long taskId = ServletHelper.getParamAsLong( req, "id" );
        LogonSession ls = WebLoginManager.getLogonSession( req );

        // Interrupt task
        try {
            getScriptManager().interruptTask( taskId, false );

        } catch( EQLException ex ) {
            throw new ServletException( ex );

        } catch( RemoteException ex ) {
            throw new ServletException( ex.detail );
        }
    }

    // ----------------------------------------------------------------- private methods

    //
    // Get ScriptManager remote interface
    //
    private ScriptManager getScriptManager()
        throws ServletException {

        return( ScriptManager )
            getRemoteObject( JNDINames.ScriptManagerRemote, ScriptManagerHome.class );
    }
}
