/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.web.www;

import com.queplix.core.utils.www.AbstractFilter;
import com.queplix.core.utils.www.HSRWImpl;
import com.queplix.core.utils.www.ServletHelper;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * <p>Puts in response scriptlet wich determining requested URI</p>
 * @author [MVT] Michael Trofimov
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:04 $
 */

public class ScriptURIFilter
    extends AbstractFilter {

    private final static String SCRIPT_VAR = "window.__FILE__";

    /**
     * Do filter
     * @param request HTTP request
     * @param response HTTP response
     * @param chain FilterChain object
     * @throws IOException
     * @throws ServletException
     */
    public void doFilter( ServletRequest request, ServletResponse response, FilterChain chain )
        throws IOException, ServletException {

        HttpServletRequest req = ( HttpServletRequest ) request;
        HttpServletResponse res = ( HttpServletResponse ) response;

        // Do chain filter
        HSRWImpl wrapper = new HSRWImpl( res );
        chain.doFilter( request, wrapper );

        // Content of requested document
        String content = wrapper.getString();

        if( content.length() > 0 ) {
            int idx = Math.max( content.lastIndexOf( "/>" ) + 2, content.lastIndexOf( "</" ) );
            content = content.substring( 0, idx )
                + "\n<script>"
                + "if(!" + SCRIPT_VAR + ")"
                + " " + SCRIPT_VAR + " = '" + req.getRequestURI() + "';"
                + "</script>\n"
                + content.substring( idx );
        }

        // Set Content-Type
        res.setContentType( ServletHelper.CONTENT_TYPE_HTML );

        /* [ALB] Got java.lang.IllegalStateException: Writer already obtained
                 // Set Content-Length
                 byte[] data = content.getBytes( ServletHelper.CHARSET_ENCODING );
                 res.setContentLength( data.length );
                 // Output response
                 res.getOutputStream().write( data );
         */

        // Output response
        res.getWriter().println( content );
    }
}
