/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.server.app.rpc;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.queplix.core.client.app.rpc.LoginService;
import com.queplix.core.client.app.rpc.RPCException;
import com.queplix.core.client.app.vo.LoginRequestObject;
import com.queplix.core.client.app.vo.LoginResult;
import com.queplix.core.integrator.IntegratorLogin;
import com.queplix.core.utils.www.GWTHelper;

/**
 * Login Service implementation.
 * @author Sultan Tezadov
 * @since 4 Oct 2006
 */
public class LoginServiceImpl extends RemoteServiceServlet implements LoginService {
    public LoginResult login(LoginRequestObject request) throws RPCException {
        LoginResult returnValue = null;
        try {
            returnValue = IntegratorLogin.login(request, getThreadLocalRequest());
        } catch (Throwable e) {
            GWTHelper.throwSerializableException(e);
        }
        return returnValue;
    }
    
    public void logout() throws RPCException {
        try {
            IntegratorLogin.logout(this.getThreadLocalRequest());
        } catch (Throwable e) {
            // do nothing; exception means the session is already invalid
        }
    }

    public void keepSessionAlive() throws RPCException {
        ; // do nothing -- HTTP session timeout counter already refreshed
    }

}
