/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.tools.fkchecker.kernel.types;

/**
 * This class encapsulates info about one point of foreign key.
 * @author dmitry.antonov
 */
public class KeyPair {

    private final String tableName;
    private final String columnName;

    public KeyPair(String tableName, String columnName) {
        this.tableName = tableName.toUpperCase();
        this.columnName = columnName.toUpperCase();
    }

    public int hashCode() {
        return tableName.hashCode() + columnName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeyPair) {
            KeyPair kp = (KeyPair) obj;
            return tableName.equals(kp.tableName) && columnName.equals(kp.columnName);
        }
        else {
            return false;
        }
    }

    public String toString() {
        return "[" + tableName + "." + columnName + "]";
    }


}
