package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.util.AbstractUIHandler;

import java.io.File;
import java.util.List;
import java.util.ArrayList;

/**
 * @author dmitry.antonov
 */
public class DBSettingsPanel extends UserInputPanel {


    private static final String INSTALL_MYSQL = "installMySQL";
    private static final String MYSQL_PATH = "MYSQL_PATH";
    private static final String MYSQL_LOGIN = "MYSQL_LOGIN";
    private static final String MYSQL_PASS = "MYSQL_PASSWORD";
    private static final String DB_PASS = "DB_PASSWORD";

    public DBSettingsPanel(InstallerFrame parent, InstallData installData) {
        //Autogenerate
        super(parent, installData);
    }


    private String[] getDBNames(String mySqlPath, String adminLogin, String adminPasswd) {
        File file = new File(mySqlPath + File.separator + "data");
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            List result = new ArrayList();
            for (int i = 0; i < files.length; i++) {
                if (files[i].isDirectory()) {
                    result.add(files[i].getName());
                }
            }
            return (String[]) result.toArray(new String[0]);
        }
        else {
            return new String[0];
        }
    }

    private boolean isDBNameUnique(String dbName) {
        dbName = dbName.toUpperCase();
        if (idata.getVariable(INSTALL_MYSQL).equals("no")) {
            String[] dbnames = getDBNames(idata.getVariable(MYSQL_PATH),
                    idata.getVariable(MYSQL_LOGIN), idata.getVariable(MYSQL_PASS));
            for (int i = 0; i < dbnames.length; i++) {
                String currentLine = dbnames[i];
                if (currentLine.toUpperCase().contains(dbName)) {
                    return askQuestion("QueWeb Database Name Warning", "Specified QueWeb DB name overrides existing and All data in the old " +
                                     "database will be lost! Are you sure?", AbstractUIHandler.CHOICES_YES_NO,
                                     AbstractUIHandler.ANSWER_NO) == AbstractUIHandler.ANSWER_YES;
                }
            }
        }
        return true;
    }

    private boolean isPasswordConfimationValid() {
        if (idata.getVariable(DB_PASS + '1').equals(idata.getVariable(DB_PASS + '2'))) {
            idata.setVariable(DB_PASS, idata.getVariable(DB_PASS + '1'));
            return true;
        }
        else {
            emitError("QueWeb DB password error", "The password was not correctly confirmed. Please ensure that the password and confirmation match exactly.");            
            return false;
        }
    }

    /*--------------------------------------------------------------------------*/
    /*--------------------------------------------------------------------------*/
    public boolean isValidated() {
        return super.isValidated() && isPasswordConfimationValid() && 
                isDBNameUnique(idata.getVariable("DB_NAME"));
    }
}
