CREATE TABLE dbo.QW_ORGANIZATION (
	[qw_orgid] [int] NOT NULL ,
	[qw_parentid] [int] NULL ,
	[qw_regionid] [int] NULL ,
	[qw_name] [varchar] (255) NOT NULL ,
	[qw_description] [varchar] (255) NULL ,
	[qw_fax] [varchar] (30) NULL ,
	[qw_phone] [varchar] (30) NULL ,
	[qw_altphone] [varchar] (30) NULL ,
	[qw_notes] [text] NULL ,
	CONSTRAINT [pk_qw_organization] PRIMARY KEY CLUSTERED ([qw_orgid]) WITH FILLFACTOR = 80  ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE dbo.QW_PRODUCT (
	[qw_productid] [int] NOT NULL,
	[qw_name] [varchar] (100) NOT NULL,
	[qw_modelnumber] [varchar] (100) NULL,
	[qw_workgroupid] [int] NULL,
	[qw_notes] [text] NULL,
	[qw_manager] [varchar] (100) NULL,
	[qw_organizationid] [int] NULL,
	[qw_managerphone] [varchar] (30) NULL,
	CONSTRAINT [pk_qw_product] PRIMARY KEY CLUSTERED ([qw_productid]) WITH FILLFACTOR = 80 ON [PRIMARY],
	CONSTRAINT [fk_qw_product_workgroup] FOREIGN KEY ([qw_workgroupid]) REFERENCES QX_WORKGROUP ([pkey]),
	CONSTRAINT [fk_qw_product_organization] FOREIGN KEY ([qw_organizationid]) REFERENCES QW_ORGANIZATION ([qw_orgid])
) ON [PRIMARY]
GO

CREATE TABLE dbo.QW_COMPONENT (
	[qw_componentid] [int] NOT NULL,
	[qw_name] [varchar] (100) NOT NULL,
	[qw_description] [varchar] (255) NULL,
	[qw_workgroupid] [int] NULL,
	[qw_productid] [int] NULL,
	CONSTRAINT [pk_qw_component] PRIMARY KEY CLUSTERED ([qw_componentid]) WITH FILLFACTOR = 80 ON [PRIMARY],
	CONSTRAINT [fk_qw_component_workgroup] FOREIGN KEY ([qw_workgroupid]) REFERENCES QX_WORKGROUP ([pkey]),
	CONSTRAINT [fk_qw_component_product] FOREIGN KEY ([qw_productid]) REFERENCES QW_PRODUCT ([qw_productid])
) ON [PRIMARY]
GO

CREATE TABLE dbo.QW_BUILDVERSION (
	[qw_buildid] [int] NOT NULL,
	[qw_name] [varchar] (100) NOT NULL,
	[qw_version] [varchar] (100) NOT NULL,
	[qw_productid] [int] NOT NULL,
	[qw_notes] [text] NULL,
	CONSTRAINT [pk_qw_buildversion] PRIMARY KEY CLUSTERED ([qw_buildid]) WITH FILLFACTOR = 80 ON [PRIMARY],
	CONSTRAINT [fk_qw_buildversion_product] FOREIGN KEY ([qw_productid]) REFERENCES QW_PRODUCT ([qw_productid])
) ON [PRIMARY]
GO

-- all new update scripts must include a line like this:
UPDATE QX_SYS_PROP SET PROP_VAL = '007' WHERE (PROP_ID = 'DB_APP_VERSION');