CREATE TABLE QW_FIELDINFO (
    qw_tablename  varchar2(128) NOT NULL ,
    qw_columnname varchar2(255) NOT NULL ,
    qw_columntype int NOT NULL ,
    qw_enumvalue  int NULL ,
    qw_enumlabel  varchar2(128) NULL
);

CREATE TABLE QW_EMPLOYEE (
    qw_employeeid   int  NOT NULL ,
    qw_userid       int  NULL ,
    qw_employeenum  varchar2  (100) NULL ,
    qw_orgid        int  NULL ,
    qw_managerid    int  NULL ,
    qw_firstname    varchar2  (100) NOT NULL ,
    qw_lastname     varchar2  (100) NOT NULL ,
    qw_fullname     varchar2  (255) NULL ,
    qw_soundex      varchar2  (4) NULL ,
    qw_title        varchar2  (40) NULL ,
    qw_department   varchar2  (100) NULL ,
    qw_building     varchar2  (100) NULL ,
    qw_site         varchar2  (100) NULL ,
    qw_location     varchar2  (100) NULL ,
    qw_mailstop     varchar2  (100) NULL ,
    qw_phone        varchar2  (30) NULL ,
    qw_altphone     varchar2  (30) NULL ,
    qw_email        varchar2  (255) NULL ,
    qw_fax          varchar2  (30) NULL ,
    qw_pager        varchar2  (30) NULL ,
    qw_webpage      varchar2  (255) NULL ,
    qw_reachby      int  NULL ,
    qw_notes        clob  NULL ,
    qw_history      int  NULL ,
    CONSTRAINT pk_qw_employee PRIMARY KEY (qw_employeeid),
    CONSTRAINT fk_qw_employee_users FOREIGN KEY (qw_userid) REFERENCES QX_USERS ( pkey )
);

CREATE TABLE QW_ADDRESS (
    qw_addressid    int  NOT NULL ,
    qw_addresstype  int  NOT NULL ,
    qw_objectid     int  NOT NULL ,
    qw_objecttype   int  NOT NULL ,
    qw_address1     varchar2(255) NULL ,
    qw_address2     varchar2(255) NULL ,
    qw_city         varchar2(100) NULL ,
    qw_state        int  NULL ,
    qw_country      varchar2(255) NULL ,
    qw_zip          varchar2(40) NULL ,
    qw_phone        varchar2(30) NULL ,
    qw_fax          varchar2(30) NULL ,
    qw_other        varchar2(255) NULL ,
    qw_notes        clob  NULL ,
    CONSTRAINT pk_qw_address PRIMARY KEY (qw_addressid)
);

CREATE TABLE QW_ORGANIZATION (
    qw_orgid int  NOT NULL ,
    qw_parentid int  NULL ,
    qw_regionid varchar2(255)  NULL ,
    qw_name varchar2(255) NOT NULL ,
    qw_cocode varchar2(255) NULL ,
    qw_description varchar2(255) NULL ,
    qw_fax varchar2(30) NULL ,
    qw_phone varchar2(30) NULL ,
    qw_altphone varchar2(30) NULL ,
    qw_notes clob  NULL ,
    CONSTRAINT pk_qw_organization PRIMARY KEY (qw_orgid)
);

CREATE TABLE QW_PRODUCT (
    qw_productid int  NOT NULL,
    qw_name varchar2(100) NOT NULL,
    qw_modelnumber varchar2(100) NULL,
    qw_notes clob  NULL,
    CONSTRAINT pk_qw_product PRIMARY KEY (qw_productid)
);

CREATE TABLE QW_COMPONENT (
    qw_componentid int  NOT NULL,
    qw_name varchar2(100) NOT NULL,
    qw_description varchar2(255) NULL,
    qw_workgroupid int  NULL,
    qw_productid int  NULL,
    CONSTRAINT pk_qw_component PRIMARY KEY (qw_componentid),
    CONSTRAINT fk_qw_component_workgroup FOREIGN KEY (qw_workgroupid) REFERENCES QX_WORKGROUP (pkey),
    CONSTRAINT fk_qw_component_product FOREIGN KEY (qw_productid) REFERENCES QW_PRODUCT (qw_productid)
);

CREATE TABLE QW_BUILDVERSION (
    qw_buildid int  NOT NULL,
    qw_name varchar2(100) NOT NULL,
    qw_version varchar2(100) NOT NULL,
    qw_productid int  NOT NULL,
    qw_notes clob  NULL,
    CONSTRAINT pk_qw_buildversion PRIMARY KEY (qw_buildid),
    CONSTRAINT fk_qw_buildversion_product FOREIGN KEY (qw_productid) REFERENCES QW_PRODUCT (qw_productid)
);

CREATE TABLE QW_CUSTOMER (
    qw_customerid int  NOT NULL,
    qw_orgid int  NULL,
    qw_firstname varchar2(100) NULL ,
    qw_lastname varchar2(100) NULL ,
    qw_fullname varchar2(255) NULL ,
    qw_soundex varchar2(4) NULL ,
    qw_title varchar2(40) NULL ,
    qw_department varchar2(100) NULL ,
    qw_mailstop varchar2(100) NULL ,
    qw_phone varchar2(30) NULL ,
    qw_altphone varchar2(30) NULL ,
    qw_email varchar2(255) NULL ,
    qw_fax varchar2(30) NULL ,
    qw_notes clob  NULL ,
    CONSTRAINT pk_qw_customer PRIMARY KEY (qw_customerid)
);

CREATE TABLE QW_ENVIRONMENT (
    qw_envid int  NOT NULL,
    qw_envconfname varchar2(100) NULL,
    qw_productid int  NOT NULL,
    qw_orgid int  NOT NULL,
    qw_appos int  NOT NULL,
    qw_apposversion int  NULL,
    qw_apphardware int  NOT NULL,
    qw_dbos int  NOT NULL,
    qw_dbosversion int  NULL,
    qw_dbhardware int  NOT NULL,
    qw_description varchar2(2000) NOT NULL,
    CONSTRAINT pk_qw_environment PRIMARY KEY (qw_envid),
    CONSTRAINT fk_qw_productid_env FOREIGN KEY (qw_productid) REFERENCES QW_PRODUCT (qw_productid),
    CONSTRAINT fk_qw_orgid_env FOREIGN KEY (qw_orgid) REFERENCES QW_ORGANIZATION (qw_orgid)
);

CREATE TABLE QW_HARDWARE (
    qw_hardwareid  int  NOT NULL,
    qw_name        varchar2(255) NOT NULL ,
    qw_description varchar2(2000) NULL ,
    CONSTRAINT pk_qw_hardware PRIMARY KEY (qw_hardwareid)
);

CREATE TABLE QW_OS (
    qw_osid  int  NOT NULL,
    qw_name        varchar2(255) NOT NULL ,
    qw_description varchar2(2000) NULL ,
    CONSTRAINT pk_qw_os PRIMARY KEY (qw_osid)
);

CREATE TABLE QW_TICKET(
    qw_ticketid             int  NOT NULL,
    qw_status               int  NOT NULL,
    qw_priority             int  NOT NULL,
    qw_type                 int  NOT NULL,
    qw_source               int  NOT NULL,
    qw_impact               int  NOT NULL,
    qw_problem              varchar2(255) NOT NULL,
    qw_action               varchar2(255) NULL,
    qw_description          varchar2(2000) NOT NULL,
    qw_solution             int  NULL,
    qw_response             varchar2(2000) NULL,
    qw_intcomments          clob NULL,
    qw_notes                clob NULL,
    qw_history              int  NULL,
    qw_descriptiontext      clob NULL,
    qw_responsetext         clob   NULL,
    qw_agentid              int  NOT NULL,
    qw_ownerid              int  NULL,
    qw_workgroupid          int  NULL,
    qw_escworkgroupid       int  NULL,
    qw_datereported         date  NULL,
    qw_dateassigned         date  NULL,
    qw_dateowned            date  NULL,
    qw_dateresolved         date  NULL,
    qw_daterequested        date  NULL,
    qw_eta                  date  NULL,
    qw_datedelivered        date  NULL,
    qw_dateclosed           date  NULL,
    qw_lastescalated        date  NULL,
    qw_lastreopened         date  NULL,
    qw_laststatuschanged    date  NULL,
    qw_datemodified         date  NULL,
    qw_holdtilldate         date  NULL,
    qw_phonetime            int  NULL,
    qw_researchtime         int  NULL,
    qw_reopencnt            int  NULL,
    qw_productid            int  NOT NULL,
    qw_componentid          int  NULL,
    qw_repbuildversionid    int  NOT NULL,
    qw_resbuildversionid    int  NULL,
    qw_category             int  NULL,
    qw_subcategory          int  NULL,
    qw_otherreason          varchar2(1000) NULL,
    qw_reasoncode           int  NULL,
    qw_repenvironmentid     int  NULL,
    qw_testenvironmentid    int  NULL,
    qw_modifiedbyid         int  NULL,
    qw_customerid           int  NULL,
    qw_employeeid           int  NULL,
    CONSTRAINT pk_qw_ticket PRIMARY KEY (qw_ticketid),
    CONSTRAINT fk_qw_ticket_agent FOREIGN KEY (qw_agentid) REFERENCES QX_USERS (pkey),    
    CONSTRAINT fk_qw_ticket_buildversion FOREIGN KEY (qw_repbuildversionid) REFERENCES QW_BUILDVERSION (qw_buildid),
    CONSTRAINT fk_qw_ticket_component FOREIGN KEY (qw_componentid) REFERENCES QW_COMPONENT (qw_componentid),
    CONSTRAINT fk_qw_ticket_escwgroup FOREIGN KEY (qw_escworkgroupid) REFERENCES QX_WORKGROUP (PKEY),
    CONSTRAINT fk_qw_ticket_owner FOREIGN KEY (qw_ownerid) REFERENCES QX_USERS (pkey),
    CONSTRAINT fk_qw_ticket_product FOREIGN KEY (qw_productid) REFERENCES QW_PRODUCT (qw_productid),
    CONSTRAINT fk_qw_ticket_resversion FOREIGN KEY (qw_resbuildversionid) REFERENCES QW_BUILDVERSION (qw_buildid),
    CONSTRAINT fk_qw_ticket_wgroup FOREIGN KEY (qw_workgroupid) REFERENCES QX_WORKGROUP (PKEY),
    CONSTRAINT fk_qw_ticket_modifiedby FOREIGN KEY (qw_modifiedbyid) REFERENCES QX_USERS (pkey),
    CONSTRAINT fk_qw_ticket_customer FOREIGN KEY (qw_customerid) REFERENCES QW_CUSTOMER (qw_customerid),
    CONSTRAINT fk_qw_ticket_employee FOREIGN KEY (qw_employeeid) REFERENCES QW_EMPLOYEE (qw_employeeid)
);

CREATE TABLE QW_EVENTTYPE (
    qw_eventid   int NOT NULL,
    qw_eventtype varchar2(100),
    CONSTRAINT pk_qw_eventid PRIMARY KEY (qw_eventid)
);

CREATE TABLE QW_TICKETEVENT (
    qw_eventid int NOT NULL ,
    qw_ticketid int NOT NULL ,
    qw_eventtype int NOT NULL,
    qw_eventdate date NULL ,
    qw_madeby int NOT NULL ,
    qw_customer int NULL ,
    qw_oldvalue varchar2(100) NULL,
    qw_newvalue varchar2(100) NULL,
    CONSTRAINT pk_qw_ticketevent PRIMARY KEY (qw_eventid),
--  CONSTRAINT fk_qw_ticketevent_ticket FOREIGN KEY (qw_ticketid) REFERENCES QW_TICKET (qw_ticketid),
    CONSTRAINT fk_qw_eventtype FOREIGN KEY (qw_eventtype) REFERENCES QW_EVENTTYPE (qw_eventid)
);

CREATE TABLE QW_INTERACTION(
    qw_interactionid   int  NOT NULL,
    qw_source          int  NOT NULL,
    qw_action          int  NULL,
    qw_problem         varchar2(255) NOT NULL,
    qw_description     varchar2(2000) NOT NULL,
    qw_intcomments     clob NULL,
    qw_notes           clob NULL,
    qw_history         int  NULL,
    qw_agentid         int  NOT NULL,
    qw_datereceived    date  NULL,
    qw_datereported    date  NULL,
    qw_phonetime       int  NULL,
    qw_researchtime    int  NULL,
    qw_customerid      int  NULL,
    qw_employeeid      int  NULL,
    qw_datemodified    date  NULL,
    qw_modifiedbyid    int  NULL,
    CONSTRAINT pk_qw_interaction PRIMARY KEY (qw_interactionid),
    CONSTRAINT fk_qw_inter_agent FOREIGN KEY (qw_agentid) REFERENCES QX_USERS (pkey),
    CONSTRAINT fk_qw_inter_modifiedby FOREIGN KEY (qw_modifiedbyid) REFERENCES QX_USERS (pkey),
    CONSTRAINT fk_qw_inter_customer FOREIGN KEY (qw_customerid) REFERENCES QW_CUSTOMER (qw_customerid),
    CONSTRAINT fk_qw_inter_employee FOREIGN KEY (qw_employeeid) REFERENCES QW_EMPLOYEE (qw_employeeid)
);

CREATE TABLE QW_INTER_TICKET(
    qw_interactionid int NOT NULL,
    qw_ticketid      int NOT NULL,
    CONSTRAINT pk_inter_ticket PRIMARY KEY (qw_interactionid, qw_ticketid)
);

CREATE TABLE QW_CATEGORY (
    qw_categoryid  int  NOT NULL,
    qw_name        varchar2(255) NOT NULL ,
    qw_description varchar2(2000) NULL ,
    CONSTRAINT pk_qw_category PRIMARY KEY (qw_categoryid)
);

CREATE TABLE QW_SUBCATEGORY (
    qw_subcategoryid int  NOT NULL,
    qw_categoryid    int  NOT NULL,
    qw_name          varchar2(255) NOT NULL ,
    qw_description   varchar2(2000) NULL ,
    CONSTRAINT pk_qw_subcategory PRIMARY KEY (qw_subcategoryid),
    CONSTRAINT fk_qw_categoryid FOREIGN KEY (qw_categoryid) REFERENCES QW_CATEGORY (qw_categoryid)
);

-- QW_CALLSNOTIFICATION

CREATE TABLE QW_TICKETNOTIFICATION (
    QW_NOTIFICATIONID                INT NOT NULL,
    QW_PRODUCTID                     INT,
    QW_ORGANIZATIONID                INT,
    QW_EMAIL                         varchar2(255),
    QW_INCLUDERECORD                 number(2,0),
    QW_SENDMODE                      number(2,0),
    QW_SUBJECT                       varchar2(255) NOT NULL,
    QW_MAILBODY                      clob NULL,
    QW_DISABLE                       number(2,0),
    QW_ONANYUPDATE                   number,
    QW_DESCRIPTION                   varchar2(255),
  CONSTRAINT PK_QW_TICKETNOTIFICATION PRIMARY KEY (QW_NOTIFICATIONID)
);

-- QW_TICKETNOTIFICATION_PRIORITY
CREATE TABLE QW_TICKETNOTIFICATION_PRIORITY (
    QW_PRIORITY                      INT,
    QW_NOTIFICATIONID                INT,
    CONSTRAINT FK_QW_PRIORITY_NOTIFICATIONID FOREIGN KEY (QW_NOTIFICATIONID) REFERENCES QW_TICKETNOTIFICATION (QW_NOTIFICATIONID)
);

-- QW_TICKETNOTIFICATION_RECIPIENT
CREATE TABLE QW_TICKETNOTIFICATION_RECIP (
    QW_RECIPIENT                     INT,
    QW_NOTIFICATIONID                INT,
    CONSTRAINT FK_QW_RECIP_NOTIFICATIONID FOREIGN KEY (QW_NOTIFICATIONID) REFERENCES QW_TICKETNOTIFICATION (QW_NOTIFICATIONID)
);

-- QW_TICKETNOTIFICATION_STATUS
CREATE TABLE QW_TICKETNOTIFICATION_STATUS (
    QW_STATUS                        INT,
    QW_NOTIFICATIONID                INT,
    CONSTRAINT FK_QW_STATUS_NOTIFICATIONID FOREIGN KEY (QW_NOTIFICATIONID) REFERENCES QW_TICKETNOTIFICATION (QW_NOTIFICATIONID)
);

-- QW_TICKETESCALATION
CREATE TABLE QW_TICKETESCALATION (
    QW_ESCALATIONID         INT NOT NULL,
    QW_PRODUCTID            INT,
    QW_PRODUCTFILTER        varchar2(255),
    QW_ORGANIZATIONID       INT,
    QW_SENDMODE             number(2,0),
    QW_EMPLOYEEID           INT,
    QW_WORKGROUPID          INT,
    QW_EMAIL                varchar2(255),
    QW_WAITTIME             INT NOT NULL,
    QW_TIMEUNIT		        number(2,0) NOT NULL,
    QW_FIREIF               INT NOT NULL,
    QW_REPEAT               number(2,0),
    QW_SUBJECT              varchar2(255),
    QW_MAILBODY             clob NULL,
    QW_DISABLE              number(2,0),
    QW_DESCRIPTION          varchar2(255),
  CONSTRAINT PK_QW_TICKETESCALATION PRIMARY KEY (QW_ESCALATIONID)
);

-- QW_TICKETESCALATION_PRIORITY
CREATE TABLE QW_TICKETESCALATION_PRIORITY (
    QW_PRIORITY                    INT,
    QW_ESCALATIONID                INT,
    CONSTRAINT FK_QW_PRIORITY_ESCALATIONID FOREIGN KEY (QW_ESCALATIONID) REFERENCES QW_TICKETESCALATION (QW_ESCALATIONID)
);

-- QW_TICKETESCALATION_STATUS
CREATE TABLE QW_TICKETESCALATION_STATUS (
    QW_STATUS                      INT,
    QW_ESCALATIONID                INT,
    CONSTRAINT FK_QW_STATUS_ESCALATIONID FOREIGN KEY (QW_ESCALATIONID) REFERENCES QW_TICKETESCALATION (QW_ESCALATIONID)
);

-- QW_TICKETESCALATION_RECIPIENT
CREATE TABLE QW_TICKETESCALATION_RECIPIENT (
    QW_RECIPIENT                   INT,
    QW_ESCALATIONID                INT,
    CONSTRAINT FK_QW_RECIPIENT_ESCALATIONID FOREIGN KEY (QW_ESCALATIONID) REFERENCES QW_TICKETESCALATION (QW_ESCALATIONID)
);

-- QW_ESCALATION_EVENT
CREATE TABLE QW_ESCALATION_EVENT (
    QW_ESCEVENTID					INT NOT NULL,
    QW_ESCALATIONID					INT NOT NULL,
    QW_TICKETID						INT NOT NULL,
    QW_NEXT_CHECK			        date  NOT NULL,
    QW_DATEMODIFIED			        date  NULL,
  CONSTRAINT PK_QW_ESCALATION_EVENT PRIMARY KEY (QW_ESCEVENTID)
);

-- QW_SOLUTION
CREATE TABLE QW_SOLUTION_CATEGORY (
    qw_categoryid  int  NOT NULL,
    qw_name        varchar2(255) NOT NULL ,
    qw_description varchar2(2000) NULL ,
    CONSTRAINT pk_qw_sol_category PRIMARY KEY (qw_categoryid)
);

CREATE TABLE QW_SOLUTION_SUBCATEGORY (
    qw_subcategoryid int  NOT NULL,
    qw_categoryid    int  NOT NULL,
    qw_name          varchar2(255) NOT NULL ,
    qw_description   varchar2(2000) NULL ,
    CONSTRAINT pk_qw_sol_subcategory PRIMARY KEY (qw_subcategoryid),
    CONSTRAINT fk_qw_sol_categoryid FOREIGN KEY (qw_categoryid) REFERENCES QW_SOLUTION_CATEGORY (qw_categoryid)
);

CREATE TABLE QW_SOLUTION (
    qw_solutionid                  INT NOT NULL,
    qw_topic                       number(2,0),
    qw_solutionstatus              number(2,0),
    qw_categoryid                  int NULL,
    qw_subcategoryid               int NULL,
    qw_productid                   int NULL,
    qw_componentid                 int NULL,
    qw_summary                     varchar2(255) NOT NULL,
    qw_problem                     varchar2(2000) NOT NULL,
    qw_problemtext                 clob NULL,
    qw_solution                    varchar2(2000) NOT NULL,
    qw_solutiontext                clob NULL,
    qw_audit                       int NULL,
    qw_intcomments                 clob NULL,
    qw_creator                     INT NOT NULL,
    qw_reviewer                    INT NULL,
    qw_publisher                   INT NULL,
    qw_modifiedby                  INT NOT NULL,
    qw_lastmodified                date NOT NULL,
    qw_datecreated                 date NOT NULL,
    qw_datereviewed                date NULL,
    qw_datepublished               date NULL,
    qw_dateexpiration              date NOT NULL,
    qw_documentid                  varchar2(100),
  CONSTRAINT PK_SOLUTION PRIMARY KEY (qw_solutionid),
  CONSTRAINT FK_QW_SOLUTION_CREATOR FOREIGN KEY (qw_creator) REFERENCES QX_USERS (PKEY),
  CONSTRAINT FK_QW_SOLUTION_PUBLISHER FOREIGN KEY (qw_publisher) REFERENCES QX_USERS (PKEY),
  CONSTRAINT FK_QW_SOLUTION_REVIEWER FOREIGN KEY (qw_reviewer) REFERENCES QX_USERS (PKEY),
  CONSTRAINT FK_QW_SOLUTION_MODIFIEDBY FOREIGN KEY (qw_modifiedby) REFERENCES QX_USERS (PKEY),
  CONSTRAINT FK_QW_SOLUTION_CATEGORY FOREIGN KEY (qw_categoryid) REFERENCES QW_SOLUTION_CATEGORY (qw_categoryid),
  CONSTRAINT FK_QW_SOLUTION_SUBCATEGORY FOREIGN KEY (qw_subcategoryid) REFERENCES QW_SOLUTION_SUBCATEGORY (qw_subcategoryid)
);

CREATE TABLE QW_WORKFLOW (
    qw_workflowid  int  NOT NULL,
    qw_objecttype  int  NOT NULL,
    qw_statusfrom  int  NULL,
    qw_statusto    int  NULL,
    qw_roleid      int  NULL,
    CONSTRAINT pk_qw_workflow PRIMARY KEY (qw_workflowid)
);
