/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.qwoss.gen;

import com.queplix.core.modules.jeo.JEObject;

import java.util.Date;

/**
 * Description.
 *
 * @author Sergei Savchuk
 */
public interface SolutionObject extends JEObject {

    Long getQw_solutionid();
    Integer getQw_topic();
    Integer getQw_solutionstatus();
    Integer getQw_categoryid();
    Integer getQw_subcategoryid();
    Integer getQw_productid();
    Integer getQw_componentid();
    Long getQw_creator();
    Long getQw_publisher();
    Long getQw_reviewer();
    Long getQw_modifiedby();
    Integer getQw_attachments();

    String getQw_problem();
    String getQw_summary();
    String getQw_problemtext();
    String getQw_audit();

    Date getQw_datecreated();
    Date getQw_datereviewed();
    Date getQw_datepublished();
    Date getQw_lastmodified();
    Date getQw_dateexpiration();

    String textQw_solutionstatus();
    Integer oldQw_solutionstatus();

    boolean isChangedQw_solutionstatus();
    boolean isChangedQw_dateexpiration();

    void setQw_solutionid(Long l);
    void setQw_topic(Integer i);
    void setQw_solutionstatus(Integer i);
    void setQw_categoryid(Integer i);
    void setQw_subcategoryid(Integer i);
    void setQw_productid(Integer i);
    void setQw_componentid(Integer i);
    void setQw_creator(Long l);
    void setQw_publisher(Long l);
    void setQw_reviewer(Long l);
    void setQw_modifiedby(Long l);
    void setQw_attachments(Integer i);

    void setQw_problem(String s);
    void setQw_summary(String s);
    void setQw_problemtext(String s);
    void setQw_audit(String s);

    void setQw_datecreated(Date d);
    void setQw_datereviewed(Date d);
    void setQw_datepublished(Date d);
    void setQw_lastmodified(Date d);
    void setQw_dateexpiration(Date d);
}
