/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.gen;

import java.util.List;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.integrator.security.LogonSession;

/**
 * <p>
 * Ticket Notification JEO handler
 * </p>
 * 
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.7 $ $Date: 2005/09/02 16:32:09 $
 */
public class TicketEscalationObjectHandler extends JEObjectHandler {

	public String getEntityName() {
		return "ticketescalation";
	}

	public Class getObjectClass() {
		return TicketEscalationObject.class;
	}

	// Select by ID
	public static JEObjectHandler selectByPkey(JEOManagerLocal local,
			LogonSession ls, long pkey) throws EQLException {
		String eql = "SELECT ticketescalation.* WHERE ticketescalation.qw_escalationid = "+ pkey;
		List hndList = local.select(ls, TicketEscalationObjectHandler.class, eql);
		if (hndList == null) 
		    return null;
		else 
		    return (JEObjectHandler) hndList.get(0);
		
	}

    public static List selectAll( JEOManagerLocal local, LogonSession ls )
        throws EQLException {
        StringBuffer eql = new StringBuffer();
        eql.append( "SELECT ticketescalation.* where ticketescalation.qw_disable=0" );
        return local.select( ls, TicketEscalationObjectHandler.class, eql.toString() );
    }
    
}
