/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.qwoss.gen;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

import java.util.List;

/**
 * Description.
 * @author Ladnev Ilya
 * @since 05-Mar-2007
 */
public class WorkflowObjectHandler extends JEObjectHandler {
    public static final String ENTITY = "workflow.management";

    /* (non-Javadoc)
     * @see JEObjectHandler.getEntityName()
     */
    public String getEntityName() {
        return ENTITY;
    }

    /* (non-Javadoc)
     * @see JEObjectHandler.getObjectClass()
     */
    public Class getObjectClass() {
        return WorkflowObject.class;
    }

    /**
     * Gets workflows by object type
     *
     * @param manager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param objId object type to search by
     * @return List of workflow objects
     * @throws EQLException
     */
    public static List selectByObjType( JEOManagerLocal manager, LogonSession ls, long objId )
        throws EQLException {

        String eql = "select workflow.management.* where workflow.management.qw_objecttype = " + objId;

        List hndList = manager.select( ls, WorkflowObjectHandler.class, eql );
        return hndList;
    }

    /**
     * Gets workflows by object type and status "to"
     *
     * @param manager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param objId object type to search by
     * @param status status "to" to search by
     * @return List of workflow objects
     * @throws EQLException
     */
    public static List selectByObjAndStatusTo( JEOManagerLocal manager, LogonSession ls, int objId, int status )
        throws EQLException {

        String eql = "select workflow.management.* where workflow.management.qw_objecttype = " + objId 
            + " and workflow.management.qw_statusto = " + status;

        List hndList = manager.select( ls, WorkflowObjectHandler.class, eql );
        return hndList;
    }
}
