/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.qwoss.inbox.utils.filters;

import com.queplix.core.modules.inbox.utils.AbstractMailFilter;
import com.queplix.core.modules.inbox.utils.log.AbstractInboxLogPublisher;
import com.queplix.core.modules.inbox.utils.log.RoutingLogPublisher;
import com.queplix.core.modules.inbox.InboxMessage;
import com.queplix.qwoss.inbox.CustomInboxHelper;
import com.queplix.qwoss.utils.ApplicationHelper;
import org.apache.regexp.RE;

/**
 * The filter gets information from the subject.
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public class AdditionalCheckFilter extends AbstractMailFilter {

    // ------------------------------------------------------- Main method

    /*
     * No javadoc
     * @see MailFilter#filterMail
     */
    public boolean filterMail(InboxMessage inboxMessage) {

        inboxPublisher.DEBUG("Email Additional check filter is started...");

        // Init log data.
        String logMessage;
        String logID = makeLogID(inboxMessage.getMessageId());

        try {
            // Additional checks.
            // =======================
            // 1. Checking for a ticket (by subject).
            String subject = inboxMessage.getSubject();
            if (subject != null) {
                Long objectId = null;
                RE re = new RE(CustomInboxHelper.TICKET_ID_PATTERN, RE.MATCH_CASEINDEPENDENT);
                if (re.match(subject)) {
                    objectId = new Long(re.getParen(1));
                    DEBUG(logName + "Ticket ID (from subject) - " + objectId);
                } // if (re.match(subject))
                if (objectId != null) {
                    inboxMessage.setObjectInfo(objectId, ApplicationHelper.TICKET_OBJECT_TYPE);
                    inboxMessage.setIsNewObject(false);
                } // if (objectId != null)
            } // if (subject != null)
        } catch (Exception ex) {
            // Logging and re-throwing the exception.
            logMessage = "There is no ticket information in the email subject. The email message subject is not consist.";
            inboxPublisher.ERROR(logMessage, inboxMessage);
            ERROR(logID + logMessage);
        } // try

        // Ok.
        inboxPublisher.DEBUG("Email Additional check filter was finished...");
        return true;

    } // filterMail()


    // ------------------------------------------------------- Protected methods

    /*
     * No javadoc
     * @see AbstractMailFilter#createInboxLogPublisher
     */
    protected AbstractInboxLogPublisher createInboxLogPublisher() {
        return new RoutingLogPublisher( getLogonSession() );
    }
}
