/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.notification;

import java.util.List;
//import com.queplix.core.modules.config.jxb.Form;
//import com.queplix.core.modules.security.Group;
import com.queplix.core.integrator.security.User;
import com.queplix.core.integrator.security.WorkGroup;

/**
 * <p>Notification manager EJB remote interface</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.5 $ $Date: 2005/08/17 09:27:16 $
 */

public interface NotificationManagerLocal
    extends javax.ejb.EJBLocalObject {

    void setAlertSeverityId( Integer alertSeverityId );
    void setSubject( String subject );
    void setMessage( String message );

    void notify( User user );
    void notifyByAlert( User user );
    void notifyByMail( User user );
    void notify( WorkGroup group, Integer tier, List userList );
    void notifyByAlert( WorkGroup group, Integer tier );
    void notifyByMail( WorkGroup group );

    void notifyByMail( String email );
}
