/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.transforms;

import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.modules.eqlext.error.EfieldTransformException;
import com.queplix.core.integrator.security.LogonSession;
import java.text.ParseException;
import com.queplix.core.modules.eqlext.transforms.EfieldTransform;
import com.queplix.core.utils.DateHelper;
import java.util.Date;

/**
 * Description.
 * @author rustem.nizamiev
 * @since 18  2007 ., 11:24
 */
public class DateToDay extends EfieldTransform {
    
    public Object toObject( LogonSession ls, Entity entity, Efield field, String s )
        throws EfieldTransformException {

        return s;
    }

    public String toString( LogonSession ls, Entity entity, Efield field, Object o ) {

        if(!(o instanceof Date)) return o.toString();
        try {
            Date diffDate = ( Date ) o;
            String nullDatePattern = "yyyy-MM-dd";
            Date nullDate = DateHelper.parseDate("1900-01-01",nullDatePattern);
            long ms = diffDate.getTime()-nullDate.getTime();
            INFO("TICKET OPEN FOR: "+ms+" ms");
            return (ms/24/3600/1000)+"";
        } catch (ParseException ex) { 
            return o.toString();
        }
    }

}


