/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.transforms;

import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eqlext.error.EfieldTransformException;
import com.queplix.core.modules.eqlext.transforms.EfieldTransform;
import com.queplix.core.modules.eql.history.HistoryConstants;  
import com.queplix.core.utils.StringHelper;
import com.queplix.core.utils.xml.TransletWrapper;
import com.queplix.core.utils.xml.XMLFactory;

import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;

/*
import java.text.ParseException;
import com.queplix.core.utils.DateHelper;
import java.util.Date;
*/

/**
 * Description.
 * @author [LIV] Ladnev Ilya
 * @since 18  2007 ., 11:24
 */
public class HistoryTransform extends EfieldTransform {
    
    public Object toObject( LogonSession ls, Entity entity, Efield field, String s )
        throws EfieldTransformException {

        return s;
    }

    public String toString( LogonSession ls, Entity entity, Efield field, Object o ) {

        INFO("History Transform started");

        char[] data = ( char[] ) o;
        String s = StringHelper.clear( String.valueOf( data ) );

        if( StringHelper.isEmpty( s ) ) {
            return s;
        } else {
            return convertToClient( s );
        }
    }
        
    private String convertToClient( String s ) {
        // Build the well-formed XML document.
        StringBuffer sb = new StringBuffer();
        sb.append( "<?xml version='1.0' encoding='UTF-8'?>" );
        sb.append( HistoryConstants.HISTORY_START_TAG );
        sb.append( s );
        sb.append( HistoryConstants.HISTORY_END_TAG );

        // Make XSLT.
        StreamSource source = new StreamSource( new CharArrayReader( sb.toString().toCharArray() ) );
        CharArrayWriter writer = new CharArrayWriter();
        TransletWrapper transletWrapper = XMLFactory.getTransletWrapper();
        INFO("Using following translet: ");
        transletWrapper.transform( source, new StreamResult( writer ), HistoryConstants.HISTORY_INLINE_HTML_TRANSLET, null );

        String ss = writer.toString();

        INFO("Result: " + ss);

        // Ok.
        return ss;
    }
}


