/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.transforms;

import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.modules.eqlext.error.EfieldTransformException;
import com.queplix.core.integrator.security.LogonSession;
import java.sql.Time;
import java.text.ParseException;
import com.queplix.core.modules.eqlext.transforms.EfieldTransform;
import com.queplix.core.utils.DateHelper;
import com.queplix.core.utils.SystemHelper;
import java.util.TimeZone;

/**
 * Description.
 * @author rustem.nizamiev
 * @since 18  2007 ., 11:24
 */
public class IntToTime extends EfieldTransform {
    
    public Object toObject( LogonSession ls, Entity entity, Efield field, String s )
        throws EfieldTransformException {

        // convert string to secs
        int secs;
        try {
            secs = DateHelper.parseTime( s, false );
        } catch( ParseException ex ) {
            throw new EfieldTransformException( ex.getMessage(), ex );
        }
        return secs;
    }
    

    public String toString( LogonSession ls, Entity entity, Efield field, Object o )
        throws EfieldTransformException {

        Time time;
        int secs = ( ( Number ) o ).intValue();
        time = toSystemTime( secs );
    
        return DateHelper.formatTime( time, "HH:mm:ss" );
    }

    //
    // Convert default (JVM) seconds to UPC (system) time
    //
    private Time toSystemTime( int secs ) {
        long systemSecs = DateHelper.convert( secs * 1000,
            TimeZone.getDefault(),
            SystemHelper.SYSTEM_TIMEZONE );
        return new Time( systemSecs );
    }
    
}


