/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.update;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.integrator.security.User;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.update.EntityUpdate;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.utils.DateHelper;
import com.queplix.core.utils.JNDINames;
import com.queplix.qwoss.gen.InteractionObject;
import com.queplix.qwoss.gen.InteractionObjectHandler;
import com.queplix.qwoss.utils.InteractionHelper;
import java.util.Date;

/**
 * Description.
 * @author rustem.nizamiev
 * @since 18  2007 ., 15:16
 */
public class InteractionUpdate extends EntityUpdate {
    
    public int beforeUpdate()
        throws EQLException {

        long time = System.currentTimeMillis();
        INFO( "TicketUpdate#beforeUpdate started..." );
        // Initialization.
        JEOManagerLocal jeoManager = ( JEOManagerLocal )
            getCOM().getLocalObject( JNDINames.JEOManager, JEOManagerLocalHome.class );
        LogonSession ls = getEUO().getSession().getLogonSession();
        User user = ls.getUser();

        // Get current interaction record.
        JEObjectHandler hnd = getJEOHandler( jeoManager, InteractionObjectHandler.class );
        InteractionObject obj = ( InteractionObject ) hnd.getJEObject();

        // Get interaction ID.
        long ticketID = obj.getQw_interactionid().longValue();

        // Now date.
        Date now = DateHelper.getNowDate();

        /**
         * CheckCallLinks function implementation
         */

        // We need to make sure we have a source.
        if( obj.isNullQw_source() ) {
            throw new EQLException( "You must first select a communication type for this interaction." );
        }
        // We need to make sure we have customer or employee.
        if( obj.isNullQw_customerid() && obj.isNullQw_employeeid() ) {
            throw new EQLException( "You must first select customer or internal customer for this interaction." );            
        }
        // We need to make sure we have customer or employee.
        if( !obj.isNullQw_customerid() && !obj.isNullQw_employeeid() ) {
            throw new EQLException( "You must specify either customer or internal customer for this interaction." );            
        }
        if(isNew() && obj.isNullQw_phonetime()){
            switch(obj.getQw_source().intValue()){
                case InteractionHelper.INC_CALL_SRC:
                case InteractionHelper.OUT_CALL_SRC:
                    Date newPressDate = obj.getQw_datereceived();
                    if(now != null && newPressDate != null){
                        long diffSec = (now.getTime() - newPressDate.getTime())/1000;
                        obj.setQw_phonetime(new Long(diffSec));
                    }
                    break;
                default: 
                    obj.setQw_phonetime(null);
            }
        }
        
        obj.setQw_modifiedbyid(new Long(user.getUserID()));
        obj.setQw_datemodified(now); 
        
        INFO( "TicketUpdate#beforeUpdate finished for ticket #" + ticketID + "." );
        INFO( "Time (ms) - " + ( System.currentTimeMillis() - time ) );

        // Ok.
        return CONTINUE;

    } // beforeUpdate()
    
}
