/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.update;


import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.ejb.EQLManagerLocal;
import com.queplix.core.modules.eql.ejb.EQLManagerLocalHome;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.update.EntityUpdate;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.utils.JNDINames;
import com.queplix.qwoss.gen.InteractionTicketObject;
import com.queplix.qwoss.gen.InteractionTicketObjectHandler;
import com.queplix.qwoss.gen.InteractionObjectHandler;
import com.queplix.qwoss.utils.TicketHelper;

/**
 * Description.
 * @author rustem.nizamiev
 * @since 18  2007 ., 15:16
 */
public class TicketPostUpdateSync extends EntityUpdate {
    
    public void afterUpdate() throws EQLException {
        // New Ticket
        if (isNew()) {
            // Initialization.
            INFO("Sync script started ...");
            JEOManagerLocal jeoManager = (JEOManagerLocal)
                    getCOM().getLocalObject(JNDINames.JEOManager, JEOManagerLocalHome.class);
            LogonSession ls = getEUO().getSession().getLogonSession();

            Long originInteractionId = getCell(TicketHelper.ORIGIN_INTERACTION_FIELD).getLong();
            Long ticketId = getCell(TicketHelper.TICKET_ID_FIELD).getLong();
            if(originInteractionId != null && originInteractionId.longValue() > 0){
                EQLManagerLocal eqlManager = ( EQLManagerLocal )getCOM().
                    getLocalObject( JNDINames.EQLManager, EQLManagerLocalHome.class );            
                boolean isInter = InteractionObjectHandler.checkByID(eqlManager, ls, originInteractionId);
                if( isInter ){ //there is interaction, thus create link to it
                    INFO("Interaction # "+originInteractionId+" is found.");
                    JEObjectHandler linkHnd = jeoManager.create( ls, InteractionTicketObjectHandler.class );
                    InteractionTicketObject linkObj = ( InteractionTicketObject ) linkHnd.getJEObject();
                    linkObj.setQw_interactionid(originInteractionId);
                    linkObj.setQw_ticketid(ticketId);
                    jeoManager.commit(linkHnd);
                    INFO("Link for Interaction # "+originInteractionId+" and Ticket # " + ticketId + " is created.");
                }
                else
                    INFO("Interaction # "+originInteractionId+" is not exist.");
            }
        }
    }
    
}