/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.utils;

/**
 * <p>Ticket escalation constants</p>
 * @author rustem.nizamiev
 */

public final class TicketEscalationHelper {

    // notification recipients
    public static final int ASSIGNED_WORKGROUP_RECIPIENT = 0;
    public static final int ASSIGNED_EMPLOYEE_RECIPIENT = 1;
    public static final int ASSIGNED_EMAIL_RECIPIENT = 2;
    
    
    // notification priorities
    public final static int CRITICAL_PRIORITY = 0;
    public final static int SERIOUS_PRIORITY = 1;
    public final static int MODERATE_PRIORITY = 2;
    public final static int LOW_PRIORITY = 3;

    // supported notification statuses
    public static final int NEW_STATUS = 0;
    public static final int ASSIGNED_STATUS = 1;
    public static final int OWNED_STATUS = 2;
    public static final int RELEASE_CANDIDATE_STATUS = 3;
    public static final int DELIVERED_STATUS = 4;
    public static final int UNREPRODUCIBLE_STATUS = 5;
    public static final int CLIENT_ISSUE_STATUS = 6;
    public static final int DUPLICATE_STATUS = 7;
    public static final int PARKED_STATUS = 8;
    public static final int TESTFAIL_STATUS = 9;
    public static final int CLOSED_STATUS = 10;
    
    // Calls escalation types.
    //public static final int NOT_ASSIGNED_TYPE = 0;
    //public static final int NOT_OWNED_TYPE = 1;
    //public static final int NOT_CLOSED_TYPE = 2;

    // Escalation 'Fire If'.
    public static final int NOT_CLOSED_FIREIF = 0;
    public static final int NOT_UPDATED_FIREIF = 1;
    public static final int NOT_ASSIGNED_FIREIF = 2;

    // Escalation delay units.
    public final static int MINUTES_DELAY_UNITS = 0;
    public final static int HOURS_DELAY_UNITS = 1;
    public static final int DAYS_DELAY_UNITS = 2;
    public static final int WORKDAYS_DELAY_UNITS = 3;
    
    // constructor
    private TicketEscalationHelper() {}

    //
    // public methods
    //

    public static Integer ticketStatus2EscalationStatus( Integer ticketStatus ) {
        if( ticketStatus == null ) {
            return null;
        }
        switch( ticketStatus.intValue() ) {
        case TicketHelper.NEW_STATUS:
            return new Integer( NEW_STATUS );
        case TicketHelper.ASSIGNED_STATUS:
            return new Integer( ASSIGNED_STATUS );
        case TicketHelper.OWNED_STATUS:
            return new Integer( OWNED_STATUS );
        case TicketHelper.RELEASE_CANDIDATE_STATUS:
            return new Integer( RELEASE_CANDIDATE_STATUS );
        case TicketHelper.DELIVERED_STATUS:
            return new Integer( DELIVERED_STATUS );
        case TicketHelper.UNREPRODUCIBLE_STATUS:
            return new Integer( UNREPRODUCIBLE_STATUS );
        case TicketHelper.CLIENT_ISSUE_STATUS:
            return new Integer( CLIENT_ISSUE_STATUS );
        case TicketHelper.DUPLICATE_STATUS:
            return new Integer( DUPLICATE_STATUS );
        case TicketHelper.PARKED_STATUS:
            return new Integer( PARKED_STATUS );
        case TicketHelper.TESTFAIL_STATUS:
            return new Integer( TESTFAIL_STATUS );
        case TicketHelper.CLOSED_STATUS:
            return new Integer( CLOSED_STATUS );
        default:
            throw new IllegalStateException( "Unsupported ticket status: " + ticketStatus );
        }
    }

    public static Integer ticketPriority2EscalationPriority( Integer ticketPriority ) {
        if( ticketPriority == null ) {
            return null;
        }
        switch( ticketPriority.intValue() ) {
        case TicketHelper.CRITICAL_PRIORITY:
            return new Integer( CRITICAL_PRIORITY );
        case TicketHelper.SERIOUS_PRIORITY:
            return new Integer( SERIOUS_PRIORITY );
        case TicketHelper.MODERATE_PRIORITY:
            return new Integer( MODERATE_PRIORITY );
        case TicketHelper.LOW_PRIORITY:
            return new Integer( LOW_PRIORITY );
        default:
            throw new IllegalStateException( "Unsupported ticket priority: " + ticketPriority );
        }
    }
    
}
