/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.utils;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.integrator.security.User;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.utils.DateHelper;
import com.queplix.qwoss.gen.TicketEventObject;
import com.queplix.qwoss.gen.TicketEventObjectHandler;
import com.queplix.qwoss.gen.TicketObject;

/**
 * TicketEventHelper class.
 *
 * @author [SSV] Savchuk Sergei.
 */
public class TicketEventHelper {

    // Captured events
    public static final int TICKET_CREATED = 0;
    public static final int STATUS_CHANGE = 1;
    public static final int PRIORITY_CHANGE = 2;
    public static final int IMPACT_CHANGE = 3;
    public static final int TYPE_CHANGE = 4;
    public static final int AGENT_CHANGE = 5;
    public static final int OWNER_CHANGE = 6;
    public static final int WORKGROUP_CHANGE = 7;

    public static void createEvent(JEOManagerLocal jeoManager, LogonSession ls, TicketObject ticketObj, int eventtype)
            throws EQLException {
        JEObjectHandler hnd = jeoManager.create(ls, TicketEventObjectHandler.class);
        TicketEventObject eventObj = (TicketEventObject) hnd.getJEObject();
        populatEvent(eventObj, ticketObj, ls.getUser(), eventtype);
        writeChanges(eventObj, ticketObj, eventtype);
        jeoManager.commit(hnd);
    }

    private static void populatEvent(TicketEventObject eventObj, TicketObject ticketObj, User user, int eventtype) {
        eventObj.setQw_ticketid(ticketObj.getQw_ticketid());
        eventObj.setQw_eventtype(eventtype);
        eventObj.setQw_eventdate(DateHelper.getNowDate());
        eventObj.setQw_madeby(user.getUserID());
        eventObj.setQw_customer(ticketObj.getQw_customerid());
    }

    private static void writeChanges(TicketEventObject eventObj, TicketObject ticketObj, int field) {
        switch (field) {
            case TICKET_CREATED:
                break;
            case STATUS_CHANGE:
                eventObj.setQw_oldvalue(ticketObj.oldTextQw_status());
                eventObj.setQw_newvalue(ticketObj.textQw_status());
                break;
            case PRIORITY_CHANGE:
                eventObj.setQw_oldvalue(ticketObj.oldTextQw_priority());
                eventObj.setQw_newvalue(ticketObj.textQw_priority());
                break;
            case IMPACT_CHANGE:
                eventObj.setQw_oldvalue(ticketObj.oldTextQw_impact());
                eventObj.setQw_newvalue(ticketObj.textQw_impact());
                break;
            case TYPE_CHANGE:
                eventObj.setQw_oldvalue(ticketObj.oldTextQw_type());
                eventObj.setQw_newvalue(ticketObj.textQw_type());
                break;
            case OWNER_CHANGE:
                eventObj.setQw_oldvalue(ticketObj.oldTextQw_ownerid());
                eventObj.setQw_newvalue(ticketObj.textQw_ownerid());
                break;
            case AGENT_CHANGE:
                eventObj.setQw_oldvalue(ticketObj.oldTextQw_agentid());
                eventObj.setQw_newvalue(ticketObj.textQw_agentid());
                break;
            case WORKGROUP_CHANGE:
                eventObj.setQw_oldvalue(ticketObj.oldTextQw_workgroupid());
                eventObj.setQw_newvalue(ticketObj.textQw_workgroupid());
                break;
        }
    }
}
