/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.utils;

import com.queplix.core.modules.alert.AlertConstants;

//import com.queplix.qsupport.update;

/**
 * <p>Ticket notification constants</p>
 * @author rustem.nizamiev
 */

public final class TicketNotificationHelper {

    // notification methods
    public final static int ALERT_METHOD = 0;
    public final static int EMAIL_METHOD = 1;

    // notification recipients
    public static final int WORKGROUP_RECIPIENT = 0;
    public static final int EMAIL_TO_RECIPIENT = 1;
    public static final int AGENT_RECIPIENT = 2;
    public static final int OWNER_RECIPIENT = 3;
    public static final int CUSTOMER_RECIPIENT = 4;
    
    // notification priorities
    public final static int CRITICAL_PRIORITY = 0;
    public final static int SERIOUS_PRIORITY = 1;
    public final static int MODERATE_PRIORITY = 2;
    public final static int LOW_PRIORITY = 3;

    // supported notification statuses
    public static final int NEW_STATUS = 0;
    public static final int ASSIGNED_STATUS = 1;
    public static final int OWNED_STATUS = 2;
    public static final int RELEASE_CANDIDATE_STATUS = 3;
    public static final int DELIVERED_STATUS = 4;
    public static final int UNREPRODUCIBLE_STATUS = 5;
    public static final int CLIENT_ISSUE_STATUS = 6;
    public static final int DUPLICATE_STATUS = 7;
    public static final int PARKED_STATUS = 8;
    public static final int TESTFAIL_STATUS = 9;
    public static final int CLOSED_STATUS = 10;
    
    // constructor
    private TicketNotificationHelper() {}

    //
    // public methods
    //

    public static Integer ticketStatus2NotificationStatus( Integer ticketStatus ) {
        if( ticketStatus == null ) {
            return null;
        }
        switch( ticketStatus.intValue() ) {
        case TicketHelper.NEW_STATUS:
            return new Integer( NEW_STATUS );
        case TicketHelper.ASSIGNED_STATUS:
            return new Integer( ASSIGNED_STATUS );
        case TicketHelper.OWNED_STATUS:
            return new Integer( OWNED_STATUS );
        case TicketHelper.RELEASE_CANDIDATE_STATUS:
            return new Integer( RELEASE_CANDIDATE_STATUS );
        case TicketHelper.DELIVERED_STATUS:
            return new Integer( DELIVERED_STATUS );
        case TicketHelper.UNREPRODUCIBLE_STATUS:
            return new Integer( UNREPRODUCIBLE_STATUS );
        case TicketHelper.CLIENT_ISSUE_STATUS:
            return new Integer( CLIENT_ISSUE_STATUS );
        case TicketHelper.DUPLICATE_STATUS:
            return new Integer( DUPLICATE_STATUS );
        case TicketHelper.PARKED_STATUS:
            return new Integer( PARKED_STATUS );
        case TicketHelper.TESTFAIL_STATUS:
            return new Integer( TESTFAIL_STATUS );
        case TicketHelper.CLOSED_STATUS:
            return new Integer( CLOSED_STATUS );
        default:
            throw new IllegalStateException( "Unsupported ticket status: " + ticketStatus );
        }
    }

    public static Integer ticketPriority2NotificationPriority( Integer ticketPriority ) {
        if( ticketPriority == null ) {
            return null;
        }
        switch( ticketPriority.intValue() ) {
        case TicketHelper.CRITICAL_PRIORITY:
            return new Integer( CRITICAL_PRIORITY );
        case TicketHelper.SERIOUS_PRIORITY:
            return new Integer( SERIOUS_PRIORITY );
        case TicketHelper.MODERATE_PRIORITY:
            return new Integer( MODERATE_PRIORITY );
        case TicketHelper.LOW_PRIORITY:
            return new Integer( LOW_PRIORITY );
        default:
            throw new IllegalStateException( "Unsupported ticket priority: " + ticketPriority );
        }
    }
    
    /**
     * Converts a ticket priority to the corresponding alert severity.
     *
     * @param ticketPriority ticket priority to convert
     * @return corresponding alert severity or NULL
     */
    public static Integer ticketPriority2AlertSeverity( Integer ticketPriority ) {
        if( ticketPriority == null ) {
            return null;
        }
        switch( ticketPriority.intValue() ) {
        case TicketHelper.CRITICAL_PRIORITY:
            return new Integer( AlertConstants.SEVERITY_CRITICAL );
        case TicketHelper.SERIOUS_PRIORITY:
            return new Integer( AlertConstants.SEVERITY_HIGH );
        case TicketHelper.MODERATE_PRIORITY:
            return new Integer( AlertConstants.SEVERITY_MEDIUM );
        case TicketHelper.LOW_PRIORITY:
            return new Integer( AlertConstants.SEVERITY_LOW );
        default:
            throw new IllegalStateException( "Unsupported ticket priority: " + ticketPriority );
        }
    }
    
}
