/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.qwoss.client.frames.mainframe;

import com.queplix.core.client.app.rpc.RPC;
import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.TextboxFieldData;
import com.queplix.core.client.common.ui.DialogHelper;
import com.queplix.core.client.frames.mainframe.DefaultOperationStrategy;
import com.queplix.core.client.frames.mainframe.FormOperations;
import com.queplix.qwoss.client.app.rpc.CustomRPC;

/**
 * The handler supports the Account form.
 * @author Konstantin Mironov
 * @since 12 Feb 2007
 */
final class AccountHandler extends DefaultOperationStrategy {

    private static final String FORM_CHECK_ACCOUNT_BUTTON = "FORM_CHECK_ACCOUNT";
    private static final String ACCOUNT_NAME_FIELD_NAME = "account_name";

    public void handleCustomButtonEvent(
            String buttonId) {
        FamgMeta.Index formIndex = getFormIndex();
        if (buttonId.equalsIgnoreCase(FORM_CHECK_ACCOUNT_BUTTON)) {
            FormOperations context = getOperationContext().getFormOperations();
            Long accountId = context.getSelectedRecordId(formIndex);
            if (accountId == null) {
                DialogHelper.showModalMessageDialog("Please select account to check");
            } else {
                TextboxFieldData accountName = (TextboxFieldData) context.getFieldData(
                        formIndex, ACCOUNT_NAME_FIELD_NAME);
                RPC.QAsyncCallback callback = new CreateLinkAsyncCallback(formIndex);
                CustomRPC.getCustomRPC().checkEmailAccount(accountId, accountName.getText(), callback);
            } // if (accountId == null)
        }
    }

    private class CreateLinkAsyncCallback extends RPC.QAsyncCallback {
        private FamgMeta.Index form;
        public CreateLinkAsyncCallback(FamgMeta.Index form) { this.form = form; }
        public void onRequestEnded(boolean success, Object result) {
            if (success) {
                String rv = (String)result;
                if (rv != null) {
                    DialogHelper.showModalMessageDialog("This account is not valid due to the issue: " + rv);
                } else {
                    DialogHelper.showModalMessageDialog("Account is valid.");
                } // if (rv != null)
                //todo ask, what we need to do here
//                form.getModel().fireDataChagendPerformed();
            } else {
                DialogHelper.showModalMessageDialog("RPC call failed.");
            } // if (success)
        } // onRequestEnded(boolean, Object)
    } // private class CreateLinkAsyncCallback
} //  public final class AccountHandler extends HadlerAdapter
