/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.qwoss.client.frames.mainframe;

import com.queplix.core.client.app.rpc.RPC;
import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.common.ui.DialogHelper;
import com.queplix.core.client.frames.mainframe.FormOperations;
import com.queplix.core.client.frames.mainframe.FormState;
import com.queplix.qwoss.client.app.rpc.CustomRPC;

/**
 * Description:
 *
 * @author sergei.savchuk
 */
public class AttachmentSolutionHandler extends AttachmentHandler {
    /*
     * Solution form id
     * It should initialized in HandlerFactory or it's siblings
     */
    private String solutionFormId;

    public void handleCustomButtonEvent(String buttonId) {
        FamgMeta.Index formIndex = getFormIndex();
        if (buttonId.equalsIgnoreCase(LINK_TO_SOLUTION)) {
            switch (getOperationContext().getFormOperations().getFormState(formIndex)) {
                case FormState.SELECTED_STATE:
                    linkAttachmentToSolution(formIndex);
                    break;
                default:
                    DialogHelper.showModalMessageDialog("This button is available only SELECTED state.");
            }
        }
        super.handleCustomButtonEvent(buttonId);
    }

    protected void linkAttachmentToSolution(FamgMeta.Index form){
        FormOperations context = getOperationContext().getFormOperations();
        Long atachmentId = context.getSelectedRecordId(form);
        FamgMeta.Index solutionIndex = (FamgMeta.Index) getOperationContext().getMetaData().getIndexByID(solutionFormId);
        Long solutionId = context.getSelectedRecordId(solutionIndex);
        if(solutionId == null){
            DialogHelper.showModalMessageDialog("The selected solution record is required to link attachment to solution.");
            return;
        }
        if(DialogHelper.showModalQuestionDialog("The link between attachment # " + atachmentId +
                        " and solution # " + solutionId + " is going to be created.")== DialogHelper.YES) {
            RPC.QAsyncCallback callback = new CreateLinkAsyncCallback();
            CustomRPC.getCustomRPC().createAttachmentSolutionLink(atachmentId, solutionId, callback);
        }
    }

    public void setSolutionFormId(String solutionFormId) {
        this.solutionFormId = solutionFormId;
    }
}
