/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.qwoss.client.frames.mainframe;

import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.FocusMeta;
import com.queplix.core.client.common.ui.DialogHelper;
import com.queplix.core.client.frames.mainframe.OperationContext;
import com.queplix.core.client.frames.mainframe.OperationTypes;
import com.queplix.core.client.i18n.I18N;

/**
 * Helps in common operations
 *
 * @author Sergey Kozmin
 * @since 16.04.2007
 */
class OperationsHelper {
    public static final String TICKET_ID_CAPTION = "Ticket : ";
    public static final String INTERACTION_ID_CAPTION = "Interaction : ";

    public static final int INTERACTION_OBJECT_TYPE = 1;
    public static final int TICKET_OBJECT_TYPE = 2;


    public static void createNewRecord(String formId,
                                       OperationContext operationContext) {
        FocusMeta.Index objIndex = operationContext.getMetaData().getIndexByID(formId);
        if( objIndex == null || !(objIndex instanceof FamgMeta.Index)){
            String message = I18N.getMessages().canNotOpenFormNewMode() + ": "
                    + formId;
            DialogHelper.showModalMessageDialog(message);
            return;
        }
        FamgMeta.Index reqFormIndex = (FamgMeta.Index)objIndex;
        operationContext.getFormOperations().activateForm(reqFormIndex);
        operationContext.getGridOperations().activateGrid(reqFormIndex);
        operationContext.getFormOperations().clearForm(reqFormIndex, false);
        operationContext.performOperation(OperationTypes.CREATE_RECORD_PROTOTYPE, reqFormIndex);
    }


    public static String formatToTime(long sec){
        if(sec < 0) return "00:00:00";
        long min = sec / 60 ;
        long tailSec = sec % 60;
        long hour = min / 60;
        long tailMin = min % 60;
        long tailHour = hour % 24;
        String rv = "";
        if(tailHour < 10 && tailHour>=0) rv+="0"+tailHour+":";
        else rv+=tailHour+":";
        if(tailMin < 10 && tailMin>=0) rv+="0"+tailMin+":";
        else rv+=tailMin+":";
        if(tailSec < 10 && tailSec>=0) rv+="0"+tailSec;
        else rv+=tailSec;
        return rv;
    }
}
