/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.qwoss.client.frames.mainframe;

import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.common.ui.DialogHelper;
import com.queplix.core.client.frames.mainframe.DefaultOperationStrategy;
import com.queplix.core.client.frames.mainframe.FormState;

import java.util.ArrayList;

/**
 * Description.
 *
 * @author Ladnev Ilya
 * @since 07 Mar 2007
 */
final class ReleaseLockHandler extends DefaultOperationStrategy {
    private static final String RELEASE_LOCK_BUTTON = "FORM_RELEASE_BUTTON";

    public void handleCustomButtonEvent(String buttonId) {
        FamgMeta.Index formIndex = getFormIndex();
        if(buttonId.equalsIgnoreCase(RELEASE_LOCK_BUTTON)) {
            int state = getOperationContext().getFormOperations().getFormState(formIndex);
            switch(state) {
                case FormState.SELECTED_STATE:
                    deleteActiveRec(formIndex);
                    break;
                default:
                    DialogHelper.showModalMessageDialog("Please select a record first.");
            }
        }
    }

    private void deleteActiveRec(FamgMeta.Index formIndex) {
        Long rowId = getOperationContext().getFormOperations().getSelectedRecordId(formIndex);
        ArrayList rowsToDelete = new ArrayList();
        rowsToDelete.add(rowId);
        deleteRecord(rowsToDelete);
    }
}
