/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.qwoss.server.app.rpc;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.queplix.core.client.app.rpc.RPCException;
import com.queplix.core.client.app.vo.EmailComposeRequestObject;
import com.queplix.core.client.app.vo.EmailComposeResponseObject;
import com.queplix.core.utils.www.GWTHelper;
import com.queplix.qwoss.client.app.rpc.CustomService;
import javax.servlet.http.HttpServletRequest;
import java.util.Collection;

/**
 * Application custom RPC methods implementation.
 * @author Sultan Tezadov
 * @since 12 Feb 2007
 */
public class CustomServiceImpl extends RemoteServiceServlet implements CustomService {

    public CustomServiceImpl() {
    }

    public Boolean createTicketInteractionLink(Long ticketID, Long interID) throws RPCException {
        Boolean returnValue = null;
        try {
            HttpServletRequest httpRequest = getThreadLocalRequest();
            GWTHelper.checkLogin(httpRequest);
            returnValue = TicketLinkRPCHelper.createTicketInteractionLink(ticketID, interID, httpRequest);
        } catch (Throwable e) {
            GWTHelper.throwSerializableException(e);
        }
        return returnValue;
    }

    public Boolean createAttachmentSolutionLink(Long atachmentId, Long solutionId) throws RPCException {
        Boolean returnValue = null;
        try {
            HttpServletRequest httpRequest = getThreadLocalRequest();
            GWTHelper.checkLogin(httpRequest);
            returnValue = AttachmentRPCHelper.createAttachmentSolutionLink(atachmentId, solutionId, httpRequest);
        } catch (Throwable e) {
            GWTHelper.throwSerializableException(e);
        }
        return returnValue;
    }


    public Boolean createAttachmentTicketLink(Long atachmentId, Long ticketId) throws RPCException {
        Boolean returnValue = null;
        try {
            HttpServletRequest httpRequest = getThreadLocalRequest();
            GWTHelper.checkLogin(httpRequest);
            returnValue = AttachmentRPCHelper.createAttachmentTicketLink(atachmentId, ticketId, httpRequest);
        } catch (Throwable e) {
            GWTHelper.throwSerializableException(e);
        }
        return returnValue;
    }

    public Boolean startTask(Long taskID) throws RPCException {
        Boolean returnValue = null;
        try {
            HttpServletRequest httpRequest = getThreadLocalRequest();
            GWTHelper.checkLogin(httpRequest);
            returnValue = QTaskHelper.startTask(taskID, httpRequest);
        } catch (Throwable e) {
            GWTHelper.throwSerializableException(e);
        }
        return returnValue;
    }

    public Boolean stopTask(Long taskID) throws RPCException {
        Boolean returnValue = null;
        try {
            HttpServletRequest httpRequest = getThreadLocalRequest();
            GWTHelper.checkLogin(httpRequest);
            returnValue = QTaskHelper.stopTask(taskID, httpRequest);
        } catch (Throwable e) {
            GWTHelper.throwSerializableException(e);
        }
        return returnValue;
    }

    public EmailComposeResponseObject sendReply(EmailComposeRequestObject request, int objectType, long objectId) throws RPCException {
        EmailComposeResponseObject returnValue = new EmailComposeResponseObject();
        try {
            HttpServletRequest httpRequest = getThreadLocalRequest();
            GWTHelper.checkLogin(httpRequest);
            returnValue.setResult(InboxRPCHelper.sendReply(request, objectType, objectId, httpRequest));
        } catch (Throwable e) {
            GWTHelper.throwSerializableException(e);
        }
        return returnValue;
    }

    public String getAccountReplyEmail(Long accountId) throws RPCException {
        String returnValue = "";
        try {
            HttpServletRequest httpRequest = getThreadLocalRequest();
            GWTHelper.checkLogin(httpRequest);
            returnValue = InboxRPCHelper.getAccountReplyEmail(accountId, httpRequest);
        } catch (Throwable e) {
            GWTHelper.throwSerializableException(e);
        }
        return returnValue;
    }
    
    public String[] getFromAndToEmail(int objectType, long objectId, boolean isCustomer, Long initCustomerId) throws RPCException {
        String[] returnValue = null;
        try {
            HttpServletRequest httpRequest = getThreadLocalRequest();
            GWTHelper.checkLogin(httpRequest);
            returnValue = TicketLinkRPCHelper.getFromAndToEmail(objectType, objectId, isCustomer, initCustomerId, httpRequest);
        } catch (Throwable e) {
            GWTHelper.throwSerializableException(e);
        }
        return returnValue;
    }
    
    public String checkEmailAccount(Long accountPkey, String accountName) throws RPCException {
        String returnValue = null;
        try {
            HttpServletRequest httpRequest = getThreadLocalRequest();
            GWTHelper.checkLogin(httpRequest);
            returnValue = AccountHelper.checkEmailAccount(accountPkey, accountName);
        } catch (Throwable e) {
            GWTHelper.throwSerializableException(e);
        } // try
        return returnValue;
    } // checkEmailAccount(Long, String, String, String, String, String) : String

    public Boolean deleteInbox(Collection inboxPkeys) throws RPCException {
        Boolean returnValue = null;
        try {
            HttpServletRequest httpRequest = getThreadLocalRequest();
            GWTHelper.checkLogin(httpRequest);
            returnValue = InboxRPCHelper.deleteInbox(inboxPkeys, httpRequest);
        } catch (Throwable e) {
            GWTHelper.throwSerializableException(e);
        } // try
        return returnValue;
    }

    public Boolean deleteAttachment(Collection attachmentPkeys) throws RPCException {
        Boolean returnValue = null;
        try {
            HttpServletRequest httpRequest = getThreadLocalRequest();
            GWTHelper.checkLogin(httpRequest);
            returnValue = AttachmentRPCHelper.deleteAttachment(attachmentPkeys, httpRequest);
        } catch (Throwable e) {
            GWTHelper.throwSerializableException(e);
        } // try
        return returnValue;
    }
}
