/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

import java.util.Collection;

/**
 * Specify all the data, that should be transferred to server to specify QForm request.
 * @author Sergey Kozmin
 */
public class AccumulatedEntitiesRequestObject extends BaseFilteredGridRequest {
    private String formID;

    public AccumulatedEntitiesRequestObject(String formID, Collection entitiyFilters,
                                            GridSearchProperties props) {
        super(props, entitiyFilters);
        this.formID = formID;
    }

    public AccumulatedEntitiesRequestObject() {
        this("default_form_id", null, null);
    }

    public String getFormID() {
        return formID;
    }

    public void setFormID(String formID) {
        this.formID = formID;
    }

}
