/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

import java.util.List;
import java.util.ArrayList;

/**
 * Base adhoc request object.
 *
 * @author Sergey Kozmin
 * @since 12.02.2007
 */
public class AdhocFiltersRequest implements IsSerializable {
    private List/*]<EntityData>[*/ filters;
    private List/*]<ReportElement>[*/ fields;

    public AdhocFiltersRequest() {
    }

    protected AdhocFiltersRequest(List filters, List fields) {
        this.filters = filters;
        this.fields = fields;
    }

    protected void init(List filters, List fields) {
        if(filters != null) {
            this.filters = filters;
        } else {
            this.filters = new ArrayList();
        }
        if(fields != null) {
            this.fields = fields;
        } else {
            this.fields = new ArrayList();
        }
    }

    public List getFilters() {
        return filters;
    }

    public List getFields() {
        return fields;
    }
}
