/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Base RPC filtered entity request.
 *
 * @author Michael Trofimov
 */
public class BaseFilteredGridRequest extends BaseGridRequest {

    /**
     * Collection of entity filters
     */
    private Collection/*<EntityData>*/ entityFilters = new ArrayList/*<EntityData>*/();

    /**
     * additional eql filter that will be included to eql request
     */
    private String eqlFilter;

    public BaseFilteredGridRequest(GridSearchProperties props,
                                   Collection/*<EntityData>*/ entityFilters,
                                   String eqlFilter) {
        super(props);
        this.eqlFilter = eqlFilter;
        setEntityFilters(entityFilters);
    }

    public BaseFilteredGridRequest(GridSearchProperties props,
                                    Collection/*<EntityData>*/ entityFilters) {
        this(props, entityFilters, null);
    }

    public BaseFilteredGridRequest() {
        super();
        setEntityFilters(null);
    }

    /**
     * Returns collection of entity filters
     * Filter has type {@link com.queplix.core.client.app.vo.EntityData}
     * @return Collection of entity filters
     */
    public Collection/*<EntityData>*/ getEntityFilters() {
        return entityFilters;
    }

    /**
     * Sets collection of entity filters
     * Filter has type {@link com.queplix.core.client.app.vo.EntityData}
     * @param entityFilters Collection of entity filters
     */
    public void setEntityFilters(Collection/*<EntityData>*/ entityFilters) {
        if(entityFilters != null) {
            this.entityFilters = entityFilters;
        } else {
            this.entityFilters = new ArrayList();
        }
    }

    public String getEqlFilter() {
        return eqlFilter;
    }

    public void setEqlFilter(String eqlFilter) {
        this.eqlFilter = eqlFilter;
    }
}
