/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

/**
 * Data container for checkbox field.
 *
 * @author Sergey Kozmin
 * @since 26.09.2006, 16:18:53
 */
public class CheckBoxData extends BaseFieldData {
    private Boolean isChecked;

    public CheckBoxData(String fieldID, Boolean checked) {
        super(fieldID);
        isChecked = checked;
    }

    public CheckBoxData() {
        this("", null);
    }

    public Boolean isChecked() {
        return isChecked;
    }

    public void setChecked(Boolean checked) {
        isChecked = checked;
    }

    public void clear() {
        isChecked = null;
    }

    public boolean isEmpty() {
        return (null == isChecked);
    }

    public FieldData cloneData() {
        return new CheckBoxData(getFieldID(), isChecked);
    }

    public boolean dataEqualsTo(FieldData data) {
        boolean ret = false;
        if(data != null && data.getFieldID().equalsIgnoreCase(getFieldID())) {
            //assume that if ids are equal, then control types are equal too (within one form)
            CheckBoxData castData = (CheckBoxData) data;
            ret = castData.isChecked == isChecked;
        }
        return ret;
    }
}
