/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;

import com.queplix.core.client.app.vo.util.InvariantDate;
import com.queplix.core.client.common.StringUtil;

import java.util.Date;

/**
 * Data container for date field.
 * @author Sergey Kozmin
 * @since 26 September 2006
 */
public class DateFieldData extends BaseFieldData {
    private InvariantDate startInvDate;
    private InvariantDate endInvDate;
    private InvariantDate nowInvDate;
    private String formatedDate;
    
    public DateFieldData(String fieldID, Date startDate, Date nowDate, String formatedDate) {
        super(fieldID);
        startInvDate = InvariantDate.fromDate(startDate);
        nowInvDate = InvariantDate.fromDate(nowDate);
        this.formatedDate = formatedDate;
    }

    public DateFieldData() {
        this("", null, null, "");
    }

    public Date getStartDate() {
        return InvariantDate.toDate(startInvDate);
    }

    public void setStartDate(Date startDate) {
        startInvDate = InvariantDate.fromDate(startDate);
    }

    public Date getNowDate() {
        return InvariantDate.toDate(nowInvDate);
    }

    public void setNowDate(Date nowDate) {
        nowInvDate = InvariantDate.fromDate(nowDate);
    }

    public void clear() {
        startInvDate = null;
        endInvDate = null;
        formatedDate = null;
    }

    public boolean isEmpty() {
        //don't need to duplicate functionality, reuse code wherever you can
        return startInvDate == null && StringUtil.isStringEmpty(formatedDate);
    }

    public String getFormatedDate() {
        return formatedDate;
    }

    public void setFormatedDate(String formatedDate) {
        this.formatedDate = formatedDate;
    }
    
    public FieldData cloneData() {
        return new DateFieldData(getFieldID(), InvariantDate.toDate(startInvDate), InvariantDate.toDate(nowInvDate), formatedDate);
    }

    public Date getEndDate() {
        return InvariantDate.toDate(endInvDate);
    }

    public void setEndDate(Date endDate) {
        endInvDate = InvariantDate.fromDate(endDate);
    }

    public boolean dataEqualsTo(FieldData data) {
        boolean ret = false;
        if(data != null && data.getFieldID().equalsIgnoreCase(getFieldID())) {
            //if ids are equal, control types are equal (within one form)
            DateFieldData castData = (DateFieldData) data;

            boolean isDatesStringsEqual = StringUtil
                    .isStringsEqualsIgnoreNulls(castData.formatedDate,
                            formatedDate);

            ret = InvariantDate.
                    isInvariantDatesEqual(castData.startInvDate, startInvDate)
                    && InvariantDate.
                    isInvariantDatesEqual(castData.nowInvDate, nowInvDate)
                    && InvariantDate.
                    isInvariantDatesEqual(castData.endInvDate, endInvDate)
                    && isDatesStringsEqual;
        }
        return ret;
    }
}
