/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Specify all the data, that should be transferred to server to specify QForm request.
 * @author Sergey Kozmin
 */
public class EntityDataRequestObject implements IsSerializable {
    protected String formID;
    /**
     * Collection of filters. Filter has type {@link FieldData}
     */
    protected Collection fieldsFilterData;
    
    protected boolean doCount = false;
    protected int page = 0;
    protected int pageSize = 20;
    
    private SortField sortField;
    
    public EntityDataRequestObject() {
        this("default_form_id", null);
    }

    public EntityDataRequestObject(String formID, Collection fieldsFilterData) {
        this.formID = formID;
        if(fieldsFilterData == null) {
            this.fieldsFilterData = new ArrayList();
        } else {
            this.fieldsFilterData = fieldsFilterData;
        }
    }
    
    public EntityDataRequestObject(String formID, Collection fieldsFilterData, boolean doCount, int page, int pageSize) {
        this.page = page;
        this.pageSize = pageSize;
        this.doCount = doCount;
        this.formID = formID;
        if(fieldsFilterData == null) {
            this.fieldsFilterData = new ArrayList();
        } else {
            this.fieldsFilterData = fieldsFilterData;
        }
    }

    public EntityDataRequestObject(String formID) {
        this(formID, null);
    }

    public String getFormID() {
        return formID;
    }

    public void setFormID(String formID) {
        this.formID = formID;
    }

    public Collection getFieldsFilterData() {
        return fieldsFilterData;
    }

    /**
     * Sets filters. Filter has type {@link FieldData}
     * @param fieldsFilterData array of elements that have type {@link FieldData} 
     */
    public void setFieldsFilterData(Collection fieldsFilterData) {
        this.fieldsFilterData = fieldsFilterData;
    }

    public boolean isDoCount() {
        return doCount;
    }

    public void setDoCount(boolean doCount) {
        this.doCount = doCount;
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public SortField getSortField() {
        return sortField;
    }

    public void setSortField(SortField sortField) {
        this.sortField = sortField;
    }
}
