/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.queplix.core.client.app.vo.uisettings.DialogUISettings;

/**
 * Represent metadata for a field.
 *
 * @author Sergey Kozmin
 * @since 13 Oct 2006
 */
public interface FieldMeta extends IsSerializable {
    public static final int CHECKBOX = 0;
    public static final int DATEFIELD = 1;
    public static final int LISTBOX = 2;
    public static final int MEMO = 3;
    public static final int MULTISELECT = 4;
    public static final int TEXTAREA = 5;
    public static final int TEXTBOX = 6;
    public static final int IN_FORM_GRID = 7;
    public static final int ENTITYREFERENCE = 8;
    public static final int ENTITYLINK = 9;
    public static final int HISTORY = 10;

    // Returns true if data was described as required.
    public boolean isRequired();

    // Returns true if data was described as readonly.
    public boolean isReadOnly();
    public boolean isSearchable();

    // Returns true if data was described as descriptive.
    public boolean isDescriptive();
    
    /**
     * Returns type of the data listed in this interface.
     * @return type of data.
     */
    public int getDataType();

    /**
     * @return unique within form id, that can be used to identify element
     */
    public String getFieldID();

    public void setFieldID(String fieldID);

    /**
     * @return field caption
     */
    public String getCaption();

    /**
     * @return Does have this field "def-src" attribute
     */
    public boolean hasDefSrcAttribute();
    
    /**
     * @return Does have this field "clear" attribute
     */
    public boolean hasClearAttribute();
    
    /**
     * Returns formId to go to on caption click event.
     */
    public FamgMeta.Index getLinkedForm();

    /**
     * Sets value of linkedForm.
     */
    public void setLinkedForm(FamgMeta.Index linkedForm);
    
    /**
     * Returns if this field can be displayed in grid
     */
    public boolean isForGrid();
    
    public void setCaption(String caption);

    public DialogUISettings getUISettings();
    
    public void setUISettings(DialogUISettings settings);

    public FieldMeta cloneElementMeta();
}
