/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/**
 * Represents focus metadata
 * @author Sergey Kozmin
 * @since 13 Oct 2006
 */
public class FocusMeta implements IsSerializable {
    public static class Index implements IsSerializable {
        public static final int FOCUS = 0;
        public static final int SUBFOCUS = 1;
        public static final int TAB = 2;
        public static final int FAMG = 3;
        public int getType() {
            return FOCUS;
        }
        public int focus;
        public void init(int focus) {
            this.focus = focus;
        }
    }
    
    private Index index;
    private String caption;
    private String icon;
    private String focusName;
    private SubFocusMeta[] subFocuses;


    public FocusMeta(String caption, String icon, String focusName, SubFocusMeta[] subFocuses) {
        index = new Index();
        this.caption = caption;
        this.icon = icon;
        this.focusName = focusName;
        if(subFocuses != null) {
            this.subFocuses = subFocuses;
        } else {
            this.subFocuses = new SubFocusMeta[0];
        }
    }

    public FocusMeta() {
        this("", "", "", null);
    }

    void initIndexes(int focusIndex) {
        index.focus = focusIndex;
        initChildrenIndexes();
    }

    private void initChildrenIndexes() {
        for (int i = 0; i < subFocuses.length; i++) {
            subFocuses[i].initIndexes(index, i);
        }
    }
    
    public String getCaption() {
        return caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public SubFocusMeta[] getSubFocuses() {
        return subFocuses;
    }

    public void setSubFocuses(SubFocusMeta[] subFocuses) {
        if(subFocuses != null) {
            this.subFocuses = subFocuses;
            initChildrenIndexes();
        }
    }

    public String getFocusName() {
        return focusName;
    }

    public void setFocusName(String focusName) {
        this.focusName = focusName;
    }

    public Index getIndex() {
        return index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public FamgMeta getFamgMeta(FamgMeta.Index index) {
        return subFocuses[index.subFocus].getFamgMeta(index);
    }

    public TabMeta getTabMeta(TabMeta.Index index) {
        return subFocuses[index.subFocus].getTabMeta(index);
    }

    public TabMeta getTabMeta(String subFocusName, String tabName) {
        TabMeta tabMeta = null;
        for (int i = 0; i < subFocuses.length; i++) {
            if(subFocuses[i].getSubFocusName().equalsIgnoreCase(subFocusName)) {
                tabMeta = subFocuses[i].getTabMeta(tabName);
                break;
            }
        }
        return tabMeta;
    }

    public FamgMeta.Index getFormIndex(String subFocusName, String tabName, String entityName) {
        FamgMeta.Index index = null;
        for (int i = 0; i < subFocuses.length; i++) {
            if(subFocuses[i].getSubFocusName().equalsIgnoreCase(subFocusName)) {
                index = subFocuses[i].getFormIndex(tabName, entityName);
                break;
            }
        }
        return index;
    }

    public TabMeta.Index getTabIndex(String subFocusName, String tabName) {
        TabMeta tabMeta = getTabMeta(subFocusName, tabName);
        return (tabMeta != null) ? tabMeta.getIndex() : null;
    }

    public SubFocusMeta.Index getSubFocusIndex(String subFocusName) {
        SubFocusMeta.Index index = null;
        for (int i = 0; i < subFocuses.length; i++) {
            if(subFocuses[i].getSubFocusName().equalsIgnoreCase(subFocusName)) {
                index = subFocuses[i].getIndex();
                break;
            }
        }
        return index;
    }

    public String getFormID(FamgMeta.Index index) {
        return subFocuses[index.subFocus].getFormID(index);
    }

    public ArrayList getAllTabMetas() {
        ArrayList al = new ArrayList();
        for (int i = 0; i < subFocuses.length; i++) {
            al.addAll(Arrays.asList(subFocuses[i].getTabs()));
        }
        return al;
    }

    public boolean isMyQueWeb() {
        return "MyQueWeb".equalsIgnoreCase(focusName);
    }

}
