/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.queplix.core.client.app.vo.util.InvariantDate;
import java.util.Date;

/**
 * Data for Format Date Request.
 * @author Aliaksandr Melnik
 * @since 22 Nov 2006
 */
public class FormatDataRequestObject implements IsSerializable {
    private InvariantDate startInvDate;
    private InvariantDate endInvDate;
   
    public FormatDataRequestObject() {
    }
    
    public FormatDataRequestObject(Date date) {
        setStartDate(date);
    }
    
    public FormatDataRequestObject(Date startDate, Date endDate) {
        setStartDate(startDate);
        setEndDate(endDate);
    }

    public Date getStartDate() {
        return InvariantDate.toDate(startInvDate);
    }

    public void setStartDate(Date startDate) {
        startInvDate = InvariantDate.fromDate(startDate);
    }

    public Date getEndDate() {
        return InvariantDate.toDate(endInvDate);
    }

    public void setEndDate(Date endDate) {
        endInvDate = InvariantDate.fromDate(endDate);
    }

}
