/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;

/**
 * This class contains history data.
 * @author: Melnik Alexander
 * @since: 11.01.2007
 */
public class HistoryFieldData extends BaseFieldData {
    private String text; //html representation
    private long recordId = -1L;

    private String historyId;

    private int historyDbId;
    
    private boolean hasHistory;

    public HistoryFieldData(String fieldID, String text, String historyId, boolean hasHistory, long recordId, int historyDbId) {
        super(fieldID);
        this.historyDbId = historyDbId;
        this.recordId = recordId;
        this.text = text;
        this.historyId = historyId;
        this.hasHistory = hasHistory;
    }
    
    public HistoryFieldData() {
        this("", "", "", false, -1L, -1);
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void clear() {
        text = "";
        historyId = "";
        hasHistory = false;
    }

    public boolean isEmpty() {
        return (text == null || "".equalsIgnoreCase(text.trim())) && !hasHistory;
    }
    
    public FieldData cloneData() {
        return new HistoryFieldData(getFieldID(), text, historyId, hasHistory, recordId, historyDbId);
    }

    public long getRecordId() {
        return recordId;
    }

    public void setRecordId(long recordId) {
        this.recordId = recordId;
    }

    public String getHistoryId() {
        return historyId;
    }

    public void setHistoryId(String historyId) {
        this.historyId = historyId;
    }

    public boolean isHasHistory() {
        return hasHistory;
    }

    public void setHasHistory(boolean hasHistory) {
        this.hasHistory = hasHistory;
    }

    public int getHistoryDbId() {
        return historyDbId;
    }

    public void setHistoryDbId(int historyDbId) {
        this.historyDbId = historyDbId;
    }

    public boolean dataEqualsTo(FieldData data) {
        boolean ret = false;
        if(data != null && data.getFieldID().equalsIgnoreCase(getFieldID())) {
            //assume that if ids are equal, then control types are equal too (within one form)
            HistoryFieldData castData = (HistoryFieldData) data;

            boolean isTextEquals = text == null ?
                    (text == castData.text) :
                    text.equals(castData.text);

            boolean isHistoryEquals = historyId == null ?
                    (historyId == castData.historyId) :
                    historyId.equals(castData.historyId);

            ret = isTextEquals
                    && isHistoryEquals
                    && castData.recordId == recordId
                    && castData.historyDbId == historyDbId
                    && castData.hasHistory == hasHistory;
        }
        return ret;
    }
}
