/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

/**
 * MetaData container for in-form grid field.
 *
 * @author Sergey Kozmin
 * @since 26.09.2006, 16:18:53
 */
public class InFormGridFieldMeta extends BaseFieldMeta {
    private String presentationEntityName;
    private GridMeta presentationGridMeta;
    /**
     * used in filter dialog
     */
    private GridMeta filteringGridMeta;
    /**
     * used in filter dialog
     */
    private FormMeta filteringFormMeta;

    public InFormGridFieldMeta(String fieldID, String caption,
                               String presentationEntityName,
                               GridMeta presentationGridMeta,
                               GridMeta filteringGridMeta,
                               FormMeta filteringFormMeta) {
        super(IN_FORM_GRID, fieldID, caption);
        this.presentationEntityName = presentationEntityName;
        this.presentationGridMeta = presentationGridMeta;
        this.filteringGridMeta = filteringGridMeta;
        this.filteringFormMeta = filteringFormMeta;
    }

    public InFormGridFieldMeta(String fieldID) {
        this(fieldID, "", "", new GridMeta(), new GridMeta(), new FormMeta());
    }

    public InFormGridFieldMeta() {
        this("");
    }

    public GridMeta getPresentationGridMeta() {
        return presentationGridMeta;
    }

    public void setPresentationGridMeta(GridMeta presentationGridMeta) {
        this.presentationGridMeta = presentationGridMeta;
    }

    public GridMeta getFilteringGridMeta() {
        return filteringGridMeta;
    }

    public void setFilteringGridMeta(GridMeta filteringGridMeta) {
        this.filteringGridMeta = filteringGridMeta;
    }

    public FormMeta getFilteringFormMeta() {
        return filteringFormMeta;
    }

    public void setFilteringFormMeta(FormMeta filteringFormMeta) {
        this.filteringFormMeta = filteringFormMeta;
    }

    public String getPresentationEntityName() {
        return presentationEntityName;
    }

    public void setPresentationEntityName(String presentationEntityName) {
        this.presentationEntityName = presentationEntityName;
    }
}
