/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

/**
 * On demand data container for multiselect field.
 *
 * @author Sergey Kozmin
 * @since 26.09.2006, 16:18:53
 */
public class MultiselectOnDemandData extends BaseFieldOnDemandData {
    private SubsetMeta availableChoises;

    public MultiselectOnDemandData(String fieldID, SubsetMeta availableChoises) {
        super(fieldID);
        setAvailableChoises(availableChoises);
    }

    public MultiselectOnDemandData() {
        this("", null);
    }

    public SubsetMeta getAvailableChoises() {
        return availableChoises;
    }

    public void setAvailableChoises(SubsetMeta availableChoises) {
        if(availableChoises == null) {
            this.availableChoises = new SubsetMeta(new SubsetItemMeta[0]);
        } else {
            this.availableChoises = availableChoises;
        }
    }
}
